/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.excel;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class ExcelPictures {
    public static void addPicture(Sheet sheet, byte[] content, int pictureType, Cell cell) {
        ExcelPictures.addPicture(sheet, content, pictureType, cell.getColumnIndex(), cell.getRowIndex(), 1);
    }

    public static void addPicture(Sheet sheet, byte[] content, int pictureType, int column, int startRow, int rowSpan) {
        Workbook wb = sheet.getWorkbook();
        int pictureIdx = wb.addPicture(content, pictureType);
        CreationHelper helper = wb.getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(column);
        anchor.setRow1(startRow);
        Drawing drawing = sheet.createDrawingPatriarch();
        Picture pict = drawing.createPicture(anchor, pictureIdx);
        int pictWidthPx = pict.getImageDimension().width;
        int pictHeightPx = pict.getImageDimension().height;
        float columnWidthPx = sheet.getColumnWidthInPixels(column);
        float[] rowHeightsPx = new float[startRow + rowSpan];
        float rowsHeightPx = 0.0f;
        for (int r = startRow; r < startRow + rowSpan; ++r) {
            Row row = sheet.getRow(r);
            float rowHeightPt = row.getHeightInPoints();
            rowHeightsPx[r - startRow] = rowHeightPt * 96.0f / 72.0f;
            rowsHeightPx += rowHeightsPx[r - startRow];
        }
        float scale = ExcelPictures.calculateScale(pictWidthPx, pictHeightPx, columnWidthPx, rowsHeightPx);
        int horCenterPosPx = Math.round(columnWidthPx / 2.0f - (float)pictWidthPx * scale / 2.0f);
        if (wb instanceof XSSFWorkbook) {
            anchor.setDx1(horCenterPosPx * 9525);
        } else if (wb instanceof HSSFWorkbook) {
            int DEFAULT_COL_WIDTH = 2560;
            anchor.setDx1(Math.round((float)horCenterPosPx * 7.0017f / 256.0f * 14.75f * (float)DEFAULT_COL_WIDTH / columnWidthPx));
        }
        int vertCenterPosPx = Math.round(rowsHeightPx / 2.0f - (float)pictHeightPx * scale / 2.0f);
        Integer row1 = null;
        rowsHeightPx = 0.0f;
        for (int r = 0; r < rowHeightsPx.length; ++r) {
            float rowHeightPx = rowHeightsPx[r];
            if (rowsHeightPx + rowHeightPx > (float)vertCenterPosPx) {
                row1 = r + startRow;
                break;
            }
            rowsHeightPx += rowHeightPx;
        }
        if (row1 != null) {
            anchor.setRow1(row1.intValue());
            if (wb instanceof XSSFWorkbook) {
                anchor.setDy1(Math.round((float)vertCenterPosPx - rowsHeightPx) * 9525);
            } else if (wb instanceof HSSFWorkbook) {
                float DEFAULT_ROW_HEIGHT = 12.75f;
                anchor.setDy1(Math.round(((float)vertCenterPosPx - rowsHeightPx) * 96.0f / 72.0f * 14.75f * DEFAULT_ROW_HEIGHT / rowHeightsPx[row1]));
            }
        }
        pict.resize();
        if (scale < 1.0f) {
            pict.resize((double)scale);
        }
    }

    private static float calculateScale(int pictWidthPx, int pictHeightPx, float columnWidthPx, float rowsHeightPx) {
        float tmpscale;
        float scale = 1.0f;
        if ((float)pictHeightPx > rowsHeightPx && (tmpscale = rowsHeightPx / (float)pictHeightPx) < scale) {
            scale = tmpscale;
        }
        if ((float)pictWidthPx > columnWidthPx && (tmpscale = columnWidthPx / (float)pictWidthPx) < scale) {
            scale = tmpscale;
        }
        return scale;
    }
}

