/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.versioning;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final String VERSION_PATTERN = "(\\d+)\\.(\\d+)(\\.(\\d+))?(\\.?-?(a|b|Alpha|Beta)(\\d+)?)?(-SNAPSHOT)?";
    private int major;
    private int minor;
    private Integer build;
    private TestType testType;
    private Integer testVersion;
    private boolean snapshot;

    public Version(String value) {
        Matcher m = Pattern.compile(VERSION_PATTERN).matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed version number");
        }
        this.major = Integer.parseInt(m.group(1));
        this.minor = Integer.parseInt(m.group(2));
        if (m.group(3) != null) {
            this.build = Integer.parseInt(m.group(4));
        }
        if (m.group(5) != null) {
            this.setTestType(m.group(6));
            this.testVersion = Integer.parseInt(m.group(7));
        }
        this.snapshot = m.group(8) != null;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public Integer getBuild() {
        return this.build;
    }

    public void setBuild(Integer build) {
        this.build = build;
    }

    public TestType getTestType() {
        return this.testType;
    }

    public void setTestType(TestType testType) {
        this.testType = testType;
    }

    public void setTestType(String testType) {
        TestType result = TestType.fromCode(testType);
        if (result == null) {
            result = TestType.fromLabel(testType);
        }
        if (result == null) {
            throw new IllegalArgumentException("Unexpected test type: " + testType);
        }
        this.testType = result;
    }

    public boolean isAlpha() {
        return this.testType == TestType.ALPHA;
    }

    public boolean isBeta() {
        return this.testType == TestType.BETA;
    }

    public Integer getTestVersion() {
        return this.testVersion;
    }

    public void setTestVersion(Integer testVersion) {
        this.testVersion = testVersion;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public int getTestLevel() {
        if (this.isAlpha()) {
            return 1;
        }
        if (this.isBeta()) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    private List<Integer> toList() {
        List<Integer> result = Arrays.asList(this.major, this.minor, this.build == null ? 0 : this.build, this.getTestLevel(), this.testVersion == null ? Integer.MAX_VALUE : this.testVersion, this.snapshot ? 0 : 1);
        return result;
    }

    @Override
    public int compareTo(Version o) {
        return this.compareTo(o, Significance.SNAPSHOT);
    }

    public int compareTo(Version o, Significance significance) {
        List<Integer> list1 = this.toList().subList(0, significance.ordinal() + 1);
        List<Integer> list2 = o.toList().subList(0, significance.ordinal() + 1);
        for (int i = 0; i < list1.size(); ++i) {
            int compareTo = list1.get(i).compareTo(list2.get(i));
            if (compareTo == 0) continue;
            return compareTo;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(".");
        sb.append(this.minor);
        if (this.build != null) {
            sb.append(".");
            sb.append(this.build);
        }
        if (this.testType != null) {
            sb.append("-");
            sb.append(this.testType.getCode());
            if (this.testVersion != null) {
                sb.append(this.testVersion);
            }
        }
        if (this.snapshot) {
            sb.append("-");
            sb.append("SNAPSHOT");
        }
        return sb.toString();
    }

    public static enum TestType {
        ALPHA("a", "Alpha"),
        BETA("b", "Beta");

        private String code;
        private String label;

        private TestType(String code, String label) {
            this.code = code;
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.label;
        }

        public static TestType fromCode(String code) {
            for (TestType testType : TestType.values()) {
                if (!testType.code.equals(code)) continue;
                return testType;
            }
            return null;
        }

        public static TestType fromLabel(String label) {
            for (TestType testType : TestType.values()) {
                if (!testType.label.equals(label)) continue;
                return testType;
            }
            return null;
        }
    }

    public static enum Significance {
        MAJOR,
        MINOR,
        BUILD,
        TEST_LEVEL,
        TEST_VERSION,
        SNAPSHOT;

    }
}

