/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.openforis.rmb.MessageConsumer;
import org.openforis.rmb.monitor.ConsumingNewMessageEvent;
import org.openforis.rmb.monitor.ConsumingTimedOutMessageEvent;
import org.openforis.rmb.monitor.Event;
import org.openforis.rmb.monitor.MessageConsumedEvent;
import org.openforis.rmb.monitor.MessageConsumptionFailedEvent;
import org.openforis.rmb.monitor.MessagePublishedEvent;
import org.openforis.rmb.monitor.MessageQueueCreatedEvent;
import org.openforis.rmb.monitor.MessageQueueSizeChangedEvent;
import org.openforis.rmb.monitor.Monitor;
import org.openforis.rmb.monitor.RetryingMessageConsumptionEvent;
import org.openforis.rmb.monitor.ThrottlingMessageRetryEvent;
import org.openforis.rmb.spi.Clock;
import org.openforis.rmb.spi.MessageProcessingUpdate;
import org.openforis.rmb.util.Is;

public class MetricsMonitor
implements Monitor<Event> {
    private final MetricRegistry metrics;
    private final Map<String, Map<String, Long>> messageHandlingTimesByConsumerId = new ConcurrentHashMap<String, Map<String, Long>>();
    private Clock clock = new Clock.SystemClock();

    public MetricsMonitor(MetricRegistry metrics) {
        Is.notNull((Object)metrics, (String)"metrics must not be null");
        this.metrics = metrics;
    }

    void setClock(Clock clock) {
        Is.notNull((Object)clock, (String)"clock must not be null");
        this.clock = clock;
    }

    public void onEvent(Event event) {
        Is.notNull((Object)event, (String)"event must not be null");
        if (event instanceof MessageQueueCreatedEvent) {
            this.messageQueueCreated((MessageQueueCreatedEvent)event);
        } else if (event instanceof MessagePublishedEvent) {
            this.messagePublished((MessagePublishedEvent)event);
        } else if (event instanceof ConsumingNewMessageEvent) {
            this.consumingNewMessage((ConsumingNewMessageEvent)event);
        } else if (event instanceof ConsumingTimedOutMessageEvent) {
            this.consumingTimedOutMessage((ConsumingTimedOutMessageEvent)event);
        } else if (event instanceof ThrottlingMessageRetryEvent) {
            this.throttlingMessageRetry((ThrottlingMessageRetryEvent)event);
        } else if (event instanceof RetryingMessageConsumptionEvent) {
            this.retryingMessageConsumption((RetryingMessageConsumptionEvent)event);
        } else if (event instanceof MessageConsumedEvent) {
            this.messageConsumed((MessageConsumedEvent)event);
        } else if (event instanceof MessageConsumptionFailedEvent) {
            this.messageConsumptionFailed((MessageConsumptionFailedEvent)event);
        } else if (event instanceof MessageQueueSizeChangedEvent) {
            this.messageQueueSizeChangedEvent((MessageQueueSizeChangedEvent)event);
        }
    }

    private void messageQueueCreated(MessageQueueCreatedEvent event) {
        this.metrics.counter("queueCount").inc();
        for (MessageConsumer consumer : event.consumers) {
            this.messageHandlingTimesByConsumerId.put(consumer.getId(), new ConcurrentHashMap());
            this.metrics.register(QueueSizeGauge.getName(event.queueId, consumer), (Metric)new QueueSizeGauge());
        }
    }

    private void messagePublished(MessagePublishedEvent event) {
        this.metrics.counter(MetricRegistry.name((String)event.queueId, (String[])new String[]{"messageCount"})).inc();
        this.metrics.meter(MetricRegistry.name((String)event.queueId, (String[])new String[]{"messageMeter"})).mark();
    }

    private void consumingNewMessage(ConsumingNewMessageEvent event) {
        long timeFromPublicationTime = this.clock.millis() - event.update.getPublicationTime().getTime();
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "timesFromPublicationToTaken"})).update(timeFromPublicationTime);
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "takenCount"})).inc();
        this.metrics.meter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "takenMeter"})).mark();
        this.recordMessage(event.update);
    }

    private void consumingTimedOutMessage(ConsumingTimedOutMessageEvent event) {
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "takenCount"})).inc();
        this.metrics.meter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "takenMeter"})).mark();
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "timedOutTakenCount"})).inc();
        this.metrics.meter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "timedOutTakenMeter"})).mark();
        this.recordMessage(event.update);
    }

    private void throttlingMessageRetry(ThrottlingMessageRetryEvent event) {
        long handlingTime = this.clock.millis() - this.handlingStartTime(event.update);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "failingHandlingTimes"})).update(handlingTime);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "failingHandlingTimes[" + event.message.getClass().getName() + "]"})).update(handlingTime);
    }

    private void retryingMessageConsumption(RetryingMessageConsumptionEvent event) {
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "retryCount"})).inc();
        this.metrics.meter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "retryMeter"})).mark();
    }

    private void messageConsumed(MessageConsumedEvent event) {
        long timeFromPublicationTime = this.clock.millis() - event.update.getPublicationTime().getTime();
        long handlingTime = this.clock.millis() - this.handlingStartTime(event.update);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "timesFromPublicationToCompletion"})).update(timeFromPublicationTime);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "handlingTimes"})).update(handlingTime);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "handlingTimes[" + event.message.getClass().getName() + "]"})).update(handlingTime);
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "takenCount"})).dec();
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "completedCount"})).inc();
        this.metrics.meter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "completedMeter"})).mark();
        this.removeMessage(event.update);
    }

    private void messageConsumptionFailed(MessageConsumptionFailedEvent event) {
        long timeFromPublicationTime = this.clock.millis() - event.update.getPublicationTime().getTime();
        long handlingTime = this.clock.millis() - this.handlingStartTime(event.update);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "timesFromPublicationToFailure"})).update(timeFromPublicationTime);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "failingHandlingTimes"})).update(handlingTime);
        this.metrics.histogram(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "failingHandlingTimes[" + event.message.getClass().getName() + "]"})).update(handlingTime);
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "takenCount"})).dec();
        this.metrics.counter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "failedCount"})).inc();
        this.metrics.meter(MetricRegistry.name((String)event.update.getQueueId(), (String[])new String[]{event.update.getConsumer().getId(), "failedMeter"})).mark();
        this.removeMessage(event.update);
    }

    private void messageQueueSizeChangedEvent(MessageQueueSizeChangedEvent event) {
        String name = QueueSizeGauge.getName(event.queueId, event.consumer);
        QueueSizeGauge gauge = (QueueSizeGauge)this.metrics.getGauges().get(name);
        if (gauge == null) {
            throw new IllegalStateException("No gauge registered with name " + name);
        }
        gauge.setSize(event.size);
    }

    private void recordMessage(MessageProcessingUpdate update) {
        Map<String, Long> messages = this.messageHandlingTimesByConsumerId.get(update.getConsumer().getId());
        messages.put(update.getMessageId(), this.clock.millis());
    }

    private void removeMessage(MessageProcessingUpdate update) {
        Map<String, Long> messages = this.messageHandlingTimesByConsumerId.get(update.getConsumer().getId());
        messages.remove(update.getMessageId());
    }

    private long handlingStartTime(MessageProcessingUpdate update) {
        Map<String, Long> messages = this.messageHandlingTimesByConsumerId.get(update.getConsumer().getId());
        return messages.get(update.getMessageId());
    }

    private static class QueueSizeGauge
    implements Gauge<Integer> {
        private AtomicInteger size = new AtomicInteger(-1);

        private QueueSizeGauge() {
        }

        public Integer getValue() {
            return this.size.get();
        }

        void setSize(int size) {
            this.size.set(size);
        }

        static String getName(String queueId, MessageConsumer consumer) {
            return MetricRegistry.name((String)queueId, (String[])new String[]{consumer.getId(), "queueSize"});
        }
    }
}

