/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.openforis.rmb.monitor.CheckingForMessageQueueSizeChangesFailedEvent;
import org.openforis.rmb.monitor.ConsumingNewMessageEvent;
import org.openforis.rmb.monitor.ConsumingTimedOutMessageEvent;
import org.openforis.rmb.monitor.Event;
import org.openforis.rmb.monitor.MessageBrokerStartedEvent;
import org.openforis.rmb.monitor.MessageBrokerStoppedEvent;
import org.openforis.rmb.monitor.MessageConsumedEvent;
import org.openforis.rmb.monitor.MessageConsumptionFailedEvent;
import org.openforis.rmb.monitor.MessageKeptAliveEvent;
import org.openforis.rmb.monitor.MessagePublishedEvent;
import org.openforis.rmb.monitor.MessageQueueCreatedEvent;
import org.openforis.rmb.monitor.MessageUpdateConflictEvent;
import org.openforis.rmb.monitor.Monitor;
import org.openforis.rmb.monitor.PollingForMessagesEvent;
import org.openforis.rmb.monitor.RetryingMessageConsumptionEvent;
import org.openforis.rmb.monitor.TakingMessagesFailedEvent;
import org.openforis.rmb.monitor.ThrottlingMessageRetryEvent;
import org.openforis.rmb.util.Is;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Slf4jLoggingMonitor
implements Monitor<Event> {
    private final Map<Class<? extends Event>, Monitor<?>> monitors = new HashMap();

    public Slf4jLoggingMonitor() {
        this.add(MessageBrokerStartedEvent.class, new LoggingMonitor<MessageBrokerStartedEvent>(){

            @Override
            public void onEvent(MessageBrokerStartedEvent event, Logger log) {
                log.debug("{} started", (Object)event.messageBroker);
            }
        });
        this.add(MessageBrokerStoppedEvent.class, new LoggingMonitor<MessageBrokerStoppedEvent>(){

            @Override
            public void onEvent(MessageBrokerStoppedEvent event, Logger log) {
                log.debug("{} stopped", (Object)event.messageBroker);
            }
        });
        this.add(MessageQueueCreatedEvent.class, new LoggingMonitor<MessageQueueCreatedEvent>(){

            @Override
            public void onEvent(MessageQueueCreatedEvent event, Logger log) {
                log.debug("MessageQueue {}: created with consumers {}", (Object)event.queueId, (Object)event.consumers);
            }
        });
        this.add(CheckingForMessageQueueSizeChangesFailedEvent.class, new LoggingMonitor<CheckingForMessageQueueSizeChangesFailedEvent>(){

            @Override
            public void onEvent(CheckingForMessageQueueSizeChangesFailedEvent event, Logger log) {
                log.error("Checking for message queue size changes failed. {}", (Throwable)event.exception);
            }
        });
        this.add(TakingMessagesFailedEvent.class, new LoggingMonitor<TakingMessagesFailedEvent>(){

            @Override
            public void onEvent(TakingMessagesFailedEvent event, Logger log) {
                log.error("Failed to take messages {}", (Object)event.maxCountByConsumer, (Object)event.exception);
            }
        });
        this.add(MessagePublishedEvent.class, new LoggingMonitor<MessagePublishedEvent>(){

            @Override
            public void onEvent(MessagePublishedEvent event, Logger log) {
                log.debug("MessageQueue {}: {} published", (Object)event.queueId, event.message);
            }
        });
        this.add(PollingForMessagesEvent.class, new LoggingMonitor<PollingForMessagesEvent>(){

            @Override
            public void onEvent(PollingForMessagesEvent event, Logger log) {
                log.trace("{} polling for messages", (Object)event.maxCountByConsumer);
            }
        });
        this.add(ConsumingNewMessageEvent.class, new LoggingMonitor<ConsumingNewMessageEvent>(){

            @Override
            public void onEvent(ConsumingNewMessageEvent event, Logger log) {
                log.debug("{} consuming new message {}", (Object)event.update.getConsumer(), event.message);
            }
        });
        this.add(ConsumingTimedOutMessageEvent.class, new LoggingMonitor<ConsumingTimedOutMessageEvent>(){

            @Override
            public void onEvent(ConsumingTimedOutMessageEvent event, Logger log) {
                log.info("{} consuming timed-out message {}", (Object)event.update.getConsumer(), event.message);
            }
        });
        this.add(RetryingMessageConsumptionEvent.class, new LoggingMonitor<RetryingMessageConsumptionEvent>(){

            @Override
            public void onEvent(RetryingMessageConsumptionEvent event, Logger log) {
                log.warn("{} retrying (#{}) to consume message {}", new Object[]{event.update.getConsumer(), event.update.getRetries(), event.message});
            }
        });
        this.add(ThrottlingMessageRetryEvent.class, new LoggingMonitor<ThrottlingMessageRetryEvent>(){

            @Override
            public void onEvent(ThrottlingMessageRetryEvent event, Logger log) {
                int delay = event.update.getConsumer().getThrottlingStrategy().determineDelayMillis(event.update.getRetries());
                log.debug("{} throttling {} millis before retrying (#{}) to consume message {}", new Object[]{event.update.getConsumer(), delay, event.update.getRetries(), event.message});
            }
        });
        this.add(MessageConsumptionFailedEvent.class, new LoggingMonitor<MessageConsumptionFailedEvent>(){

            @Override
            public void onEvent(MessageConsumptionFailedEvent event, Logger log) {
                log.error("{} failed, after {} retries, to consume message {}", new Object[]{event.update.getConsumer(), event.update.getRetries(), event.message, event.e});
            }
        });
        this.add(MessageKeptAliveEvent.class, new LoggingMonitor<MessageKeptAliveEvent>(){

            @Override
            public void onEvent(MessageKeptAliveEvent event, Logger log) {
                log.debug("{} sent keep-alive for {}", (Object)event.update.getConsumer(), event.message);
            }
        });
        this.add(MessageConsumedEvent.class, new LoggingMonitor<MessageConsumedEvent>(){

            @Override
            public void onEvent(MessageConsumedEvent event, Logger log) {
                log.debug("{}, after {} retries, consumed {}", new Object[]{event.update.getConsumer(), event.update.getRetries(), event.message});
            }
        });
        this.add(MessageUpdateConflictEvent.class, new LoggingMonitor<MessageUpdateConflictEvent>(){

            @Override
            public void onEvent(MessageUpdateConflictEvent event, Logger log) {
                log.error("{} had a message update conflict for message {}", (Object)event.update.getConsumer(), event.message);
            }
        });
    }

    public void onEvent(Event event) {
        Is.notNull((Object)event, (String)"event must not be null");
        Monitor<?> monitor = this.monitors.get(event.getClass());
        if (monitor != null) {
            monitor.onEvent(event);
        }
    }

    private <T extends Event> void add(Class<T> eventType, final LoggingMonitor<T> monitor) {
        this.monitors.put(eventType, new Monitor<T>(eventType){
            final Logger log;
            {
                this.log = LoggerFactory.getLogger((Class)clazz);
            }

            public void onEvent(T event) {
                monitor.onEvent(event, this.log);
            }
        });
    }

    private static abstract class LoggingMonitor<T extends Event> {
        private LoggingMonitor() {
        }

        protected abstract void onEvent(T var1, Logger var2);
    }
}

