/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.spring;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.openforis.rmb.jdbc.JdbcConnectionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;

public final class SpringJdbcConnectionManager
implements JdbcConnectionManager {
    private final DataSource dataSource;

    public SpringJdbcConnectionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        return DataSourceUtils.doGetConnection((DataSource)this.dataSource);
    }

    public void releaseConnection(Connection connection) {
        try {
            DataSourceUtils.doReleaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
        catch (SQLException sQLException) {}
    }
}

