/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.spring;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.openforis.rmb.MessageBroker;
import org.openforis.rmb.MessageQueue;
import org.openforis.rmb.RepositoryMessageBroker;
import org.openforis.rmb.jdbc.JdbcConnectionManager;
import org.openforis.rmb.jdbc.JdbcMessageRepository;
import org.openforis.rmb.monitor.Event;
import org.openforis.rmb.monitor.Monitor;
import org.openforis.rmb.spi.MessageRepository;
import org.openforis.rmb.spi.MessageSerializer;
import org.openforis.rmb.spi.TransactionSynchronizer;
import org.openforis.rmb.spring.SpringJdbcConnectionManager;
import org.openforis.rmb.spring.SpringTransactionSynchronizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;

public final class SpringJdbcMessageBroker
implements MessageBroker,
InitializingBean,
SmartLifecycle {
    private final AtomicBoolean running = new AtomicBoolean();
    private final DataSource dataSource;
    private MessageBroker messageBroker;
    private String tablePrefix = "";
    private MessageSerializer messageSerializer;
    private List<Monitor<Event>> monitors;
    private Long repositoryWatcherPollingPeriodSeconds;

    public SpringJdbcMessageBroker(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        RepositoryMessageBroker.Builder builder = RepositoryMessageBroker.builder((MessageRepository)new JdbcMessageRepository((JdbcConnectionManager)new SpringJdbcConnectionManager(this.dataSource), this.tablePrefix), (TransactionSynchronizer)new SpringTransactionSynchronizer(this.dataSource));
        if (this.messageSerializer != null) {
            builder.messageSerializer(this.messageSerializer);
        }
        if (this.monitors != null) {
            for (Monitor<Event> monitor : this.monitors) {
                builder.monitor(monitor);
            }
        }
        if (this.repositoryWatcherPollingPeriodSeconds != null) {
            builder.repositoryWatcherPollingSchedule(this.repositoryWatcherPollingPeriodSeconds.longValue(), TimeUnit.SECONDS);
        }
        this.messageBroker = builder.build();
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setMessageSerializer(MessageSerializer messageSerializer) {
        this.messageSerializer = messageSerializer;
    }

    public void setMonitors(List<Monitor<Event>> monitors) {
        this.monitors = monitors;
    }

    public void setRepositoryWatcherPollingPeriodSeconds(Long repositoryWatcherPollingPeriodSeconds) {
        this.repositoryWatcherPollingPeriodSeconds = repositoryWatcherPollingPeriodSeconds;
    }

    public void start() {
        this.running.set(true);
        this.messageBroker.start();
    }

    public void stop() {
        this.running.set(false);
        this.messageBroker.stop();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public <M> MessageQueue.Builder<M> queueBuilder(String queueId, Class<M> messageType) {
        return this.messageBroker.queueBuilder(queueId, messageType);
    }

    public <M> MessageQueue.Builder<M> queueBuilder(String queueId) {
        return this.messageBroker.queueBuilder(queueId);
    }
}

