/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.spring;

import java.util.concurrent.TimeUnit;
import org.openforis.rmb.KeepAliveMessageHandler;
import org.openforis.rmb.MessageConsumer;
import org.openforis.rmb.MessageHandler;
import org.openforis.rmb.spi.ThrottlingStrategy;
import org.openforis.rmb.util.Is;
import org.springframework.beans.factory.InitializingBean;

public final class SpringMessageConsumer<M>
implements InitializingBean {
    private final MessageConsumer.Builder<M> builder;
    private MessageConsumer<M> consumer;
    private Integer messagesHandledInParallel;
    private Integer retries;
    private ThrottlingStrategy throttlingStrategy;
    private Integer timeoutSeconds;

    public SpringMessageConsumer(String consumerId, MessageHandler<M> messageHandler) {
        this(consumerId, messageHandler, null);
    }

    public SpringMessageConsumer(String consumerId, KeepAliveMessageHandler<M> keepAliveMessageHandler) {
        this(consumerId, null, keepAliveMessageHandler);
    }

    private SpringMessageConsumer(String consumerId, MessageHandler<M> messageHandler, KeepAliveMessageHandler<M> keepAliveMessageHandler) {
        Is.hasText((String)consumerId, (String)"consumerId must be specified");
        if (messageHandler == null && keepAliveMessageHandler == null) {
            throw new IllegalArgumentException("messageHandler must not be null");
        }
        this.builder = messageHandler == null ? MessageConsumer.builder((String)consumerId, keepAliveMessageHandler) : MessageConsumer.builder((String)consumerId, messageHandler);
    }

    MessageConsumer<M> getDelegate() {
        return this.consumer;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messagesHandledInParallel != null) {
            if (this.messagesHandledInParallel < 1) {
                throw new IllegalArgumentException("A consumer must have a messagesHandledInParallel of at least one");
            }
            this.builder.messagesHandledInParallel(this.messagesHandledInParallel.intValue());
        }
        if (this.throttlingStrategy == null && this.retries != null && this.retries > 0) {
            this.builder.retry(this.retries.intValue(), ThrottlingStrategy.ExponentialBackoff.upTo((int)1, (TimeUnit)TimeUnit.MINUTES));
        } else if (this.throttlingStrategy != null && (this.retries == null || this.retries < 1)) {
            this.builder.retryUntilSuccess(this.throttlingStrategy);
        } else if (this.throttlingStrategy != null && this.retries > 0) {
            this.builder.retry(this.retries.intValue(), this.throttlingStrategy);
        } else if (this.throttlingStrategy != null && this.retries < 1) {
            this.builder.retryUntilSuccess(this.throttlingStrategy);
        }
        if (this.timeoutSeconds != null) {
            this.builder.timeout(this.timeoutSeconds.intValue(), TimeUnit.SECONDS);
        }
        this.consumer = this.builder.build();
    }

    public void setMessagesHandledInParallel(int messagesHandledInParallel) {
        Is.greaterThenZero((int)messagesHandledInParallel, (String)"A consumer must be able to handle at least one message at a time");
        this.messagesHandledInParallel = messagesHandledInParallel;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setThrottlingStrategy(ThrottlingStrategy throttlingStrategy) {
        this.throttlingStrategy = throttlingStrategy;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        Is.greaterThenZero((int)this.messagesHandledInParallel, (String)"Timeout must be at least one second");
        this.timeoutSeconds = timeoutSeconds;
    }
}

