/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.spring;

import java.util.List;
import org.openforis.rmb.MessageBroker;
import org.openforis.rmb.MessageQueue;
import org.openforis.rmb.spring.SpringMessageConsumer;

public final class SpringMessageQueue<M>
implements MessageQueue<M> {
    private final MessageQueue<M> delegate;

    public SpringMessageQueue(MessageBroker messageBroker, String queueId, List<SpringMessageConsumer<M>> consumers) {
        MessageQueue.Builder builder = messageBroker.queueBuilder(queueId);
        for (SpringMessageConsumer<M> consumer : consumers) {
            builder.consumer(consumer.getDelegate());
        }
        this.delegate = builder.build();
    }

    public void publish(M message) {
        this.delegate.publish(message);
    }
}

