/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.spring;

import javax.sql.DataSource;
import org.openforis.rmb.spi.TransactionSynchronizer;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class SpringTransactionSynchronizer
implements TransactionSynchronizer {
    private final DataSource dataSource;

    public SpringTransactionSynchronizer(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isInTransaction() {
        DataSource targetDataSource = this.determineTargetDataSource();
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)targetDataSource);
        return conHolder != null;
    }

    public void notifyOnCommit(final TransactionSynchronizer.CommitListener listener) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                listener.committed();
            }
        });
    }

    private DataSource determineTargetDataSource() {
        if (this.dataSource instanceof DelegatingDataSource) {
            return ((DelegatingDataSource)this.dataSource).getTargetDataSource();
        }
        return this.dataSource;
    }
}

