/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.rmb.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import org.openforis.rmb.spi.MessageSerializer;
import org.openforis.rmb.util.Is;

public class XStreamMessageSerializer
implements MessageSerializer {
    private final XStream xstream;

    public XStreamMessageSerializer() {
        this.xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
    }

    public XStreamMessageSerializer(XStream xstream) {
        Is.notNull((Object)xstream, (String)"xstream must not be null");
        this.xstream = xstream;
    }

    public Object serialize(Object message) throws MessageSerializer.SerializationFailed {
        Is.notNull((Object)message, (String)"message must not be null");
        try {
            return this.xstream.toXML(message);
        }
        catch (XStreamException e) {
            throw new MessageSerializer.SerializationFailed("Failed to serialize " + message, (Exception)((Object)e));
        }
    }

    public Object deserialize(Object serializedMessage) throws MessageSerializer.DeserilizationFailed {
        Is.notNull((Object)serializedMessage, (String)"serializedMessage must not be null");
        if (!(serializedMessage instanceof String)) {
            throw new IllegalArgumentException("Expected serialized message to be a string. Was a " + serializedMessage.getClass());
        }
        try {
            return this.xstream.fromXML((String)serializedMessage);
        }
        catch (XStreamException e) {
            throw new MessageSerializer.DeserilizationFailed("Failed to deserialize " + serializedMessage, (Exception)((Object)e));
        }
    }
}

