/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.graph;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import net.sf.exlp.util.io.StringIO;
import org.openfuxml.xml.addon.graph.Edge;
import org.openfuxml.xml.addon.graph.Graph;
import org.openfuxml.xml.addon.graph.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDotConverter {
    static final Logger logger = LoggerFactory.getLogger(GraphDotConverter.class);
    private static final String ls = "\n";
    private static final String q = "\"";
    private StringBuffer sb;
    private String code;
    private String label;
    private Map<Long, Node> mapNodes;

    public GraphDotConverter(String code, String label) {
        this.code = code;
        this.label = label;
        this.mapNodes = new Hashtable<Long, Node>();
        this.sb = new StringBuffer();
    }

    public String convert(Graph ofxGraph) {
        for (Node n : ofxGraph.getNodes().getNode()) {
            this.mapNodes.put(n.getId(), n);
        }
        this.sb.append("digraph ").append(this.label).append(" {").append(ls);
        for (Edge e : ofxGraph.getEdges().getEdge()) {
            Node nSrc = this.mapNodes.get(e.getFrom());
            Node nDst = this.mapNodes.get(e.getTo());
            this.sb.append(q).append(nSrc.getLabel()).append(q);
            this.sb.append(" -> ");
            this.sb.append(q).append(nDst.getLabel()).append(q);
            this.sb.append(" ");
            if (!e.isDirected()) {
                this.sb.append("[dir=none]");
            }
            this.sb.append(";").append(ls);
        }
        this.sb.append("}").append(ls);
        return this.sb.toString();
    }

    public void save(File f) {
        StringIO.writeTxt((File)f, (String)this.sb.toString());
    }
}

