/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.generic;

import java.awt.Paint;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.log4j.Logger;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.openfuxml.addon.chart.data.jaxb.Axis;
import org.openfuxml.addon.chart.data.jaxb.Chart;
import org.openfuxml.addon.chart.renderer.generic.AbstractChartRenderer;
import org.openfuxml.addon.chart.util.AxisFactory;
import org.openfuxml.addon.chart.util.ChartColorFactory;
import org.openfuxml.addon.chart.util.OfxChartTypeResolver;
import org.openfuxml.addon.chart.util.TimePeriodFactory;

public class XYPlotRenderer
extends AbstractChartRenderer {
    static Logger logger = Logger.getLogger(XYPlotRenderer.class);
    protected TimePeriodFactory.OfxChartTimePeriod ofxTimePeriod;

    @Override
    protected void setSpecialColors() {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setRangeGridlinePaint((Paint)ChartColorFactory.createColor(this.ofxChart, ChartColorFactory.Area.gridRange));
        plot.setDomainGridlinePaint((Paint)ChartColorFactory.createColor(this.ofxChart, ChartColorFactory.Area.gridDomain));
    }

    @Override
    protected void setSpecialGrid() {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        Chart.Grid grid = this.ofxChart.getGrid();
        if (grid.isSetDomain()) {
            plot.setDomainGridlinesVisible(grid.isDomain());
        }
        if (grid.isSetRange()) {
            plot.setRangeGridlinesVisible(grid.isRange());
        }
    }

    protected void setTimePeriod() {
        if (this.ofxChart.getCharttype().isSetTimeseries() && this.ofxChart.getCharttype().getTimeseries().isSetTimePeriod()) {
            logger.debug((Object)("checking=" + this.ofxChart.getCharttype().getTimeseries().getTimePeriod()));
            try {
                this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.valueOf(this.ofxChart.getCharttype().getTimeseries().getTimePeriod());
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("timePeriod " + this.ofxChart.getCharttype().getTimeseries().getTimePeriod() + " is not valid, using Hour as default"));
                this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.Hour;
            }
        } else if (this.ofxChart.getCharttype().isSetGantt() && this.ofxChart.getCharttype().getGantt().isSetTimePeriod()) {
            this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.valueOf(this.ofxChart.getCharttype().getGantt().getTimePeriod());
        } else {
            logger.warn((Object)"chart/charttype/timeseries/@timePeriod is not set!!");
            logger.warn((Object)"Using default: Hour");
            this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.Hour;
        }
    }

    @Override
    protected void setAxis(Axis ofxAxis, OfxChartTypeResolver.AxisOrientation axisOrientation) {
        JaxbUtil.debug((Object)ofxAxis);
        NumberAxis axis = null;
        switch (OfxChartTypeResolver.getAxisType(ofxAxis.getAxisType())) {
            case Number: {
                axis = AxisFactory.createNumberAxis(ofxAxis);
                break;
            }
            case Date: {
                axis = AxisFactory.createPeriodAxis(ofxAxis);
                break;
            }
            default: {
                axis = new NumberAxis();
                AxisFactory.labelAxisAxis((org.jfree.chart.axis.Axis)axis, ofxAxis);
            }
        }
        if (axis != null) {
            XYPlot plot = (XYPlot)this.chart.getPlot();
            switch (axisOrientation) {
                case range0: {
                    plot.setRangeAxis((ValueAxis)axis);
                    break;
                }
                case domain: {
                    plot.setDomainAxis((ValueAxis)axis);
                }
            }
        }
    }
}

