/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.timeseries;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.openfuxml.addon.chart.data.jaxb.Chart;
import org.openfuxml.addon.chart.data.jaxb.Container;
import org.openfuxml.addon.chart.renderer.generic.OfxChartRenderer;
import org.openfuxml.addon.chart.renderer.generic.XYPlotRenderer;
import org.openfuxml.addon.chart.util.ChartLabelResolver;

public abstract class AbstractTimeSeriesChartRenderer
extends XYPlotRenderer
implements OfxChartRenderer {
    static Log logger = LogFactory.getLog(AbstractTimeSeriesChartRenderer.class);

    @Override
    public JFreeChart render(Chart ofxChart) {
        this.ofxChart = ofxChart;
        this.setTimePeriod();
        this.chart = ChartFactory.createTimeSeriesChart((String)ChartLabelResolver.getTitle(ofxChart), null, null, (XYDataset)this.createDataset(ofxChart.getContainer()), (boolean)ofxChart.isLegend(), (boolean)true, (boolean)false);
        this.setColors();
        this.setGrid();
        this.setAxis();
        return this.chart;
    }

    protected RegularTimePeriod getRtp(Date d) {
        Hour rtp;
        switch (this.ofxTimePeriod) {
            case Hour: {
                rtp = new Hour(d);
                break;
            }
            case Day: {
                rtp = new Day(d);
                break;
            }
            case Month: {
                rtp = new Month(d);
                break;
            }
            default: {
                rtp = new Hour(d);
            }
        }
        return rtp;
    }

    protected TimeSeriesCollection createDataset(List<Container> lContainer) {
        logger.warn((Object)"This method must be @overridden");
        return null;
    }
}

