/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.timeseries;

import java.util.Date;
import java.util.List;
import net.sf.exlp.util.DateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.openfuxml.addon.chart.data.jaxb.Container;
import org.openfuxml.addon.chart.data.jaxb.Data;
import org.openfuxml.addon.chart.renderer.generic.OfxChartRenderer;
import org.openfuxml.addon.chart.renderer.timeseries.AbstractTimeSeriesChartRenderer;
import org.openfuxml.addon.chart.renderer.timeseries.TimeSeriesGapNullifier;
import org.openfuxml.addon.chart.util.TimePeriodFactory;

public class TimeSeriesChartRenderer
extends AbstractTimeSeriesChartRenderer
implements OfxChartRenderer {
    static Log logger = LogFactory.getLog(TimeSeriesChartRenderer.class);

    public TimeSeriesChartRenderer() {
        logger.debug((Object)("Using: " + this.getClass().getSimpleName()));
    }

    @Override
    protected TimeSeriesCollection createDataset(List<Container> lContainer) {
        TimeSeriesGapNullifier gapNuller = null;
        boolean nullifyGaps = TimeSeriesGapNullifier.gapNullerActivated(this.ofxChart.getCharttype().getTimeseries());
        if (nullifyGaps) {
            TimePeriodFactory.OfxChartTimePeriod timePeriod = TimePeriodFactory.OfxChartTimePeriod.valueOf(this.ofxChart.getCharttype().getTimeseries().getTimePeriod());
            gapNuller = new TimeSeriesGapNullifier(timePeriod);
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (Container container : lContainer) {
            if (nullifyGaps) {
                container = gapNuller.nullifyGapsInContainer(container);
            }
            TimeSeries ts = new TimeSeries((Comparable)((Object)container.getLabel()));
            for (Data data : container.getData()) {
                Date d = DateUtil.getDateFromInt((int)data.getRecord().getYear(), (int)data.getRecord().getMonth(), (int)data.getRecord().getDay());
                RegularTimePeriod rtp = this.getRtp(d);
                if (data.isSetY()) {
                    ts.addOrUpdate(rtp, data.getY());
                    continue;
                }
                ts.addOrUpdate(rtp, null);
            }
            dataset.addSeries(ts);
            logger.info((Object)"Add here TS with same color from container");
        }
        return dataset;
    }
}

