/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.util;

import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.Year;
import org.openfuxml.addon.chart.data.jaxb.Axis;
import org.openfuxml.addon.chart.data.jaxb.AxisType;
import org.openfuxml.addon.chart.data.jaxb.Chart;
import org.openfuxml.addon.chart.data.jaxb.Label;
import org.openfuxml.addon.chart.util.OfxChartTypeResolver;
import org.openfuxml.addon.chart.util.TimePeriodFactory;

public class AxisFactory {
    static Log logger = LogFactory.getLog(AxisFactory.class);

    public static synchronized org.jfree.chart.axis.Axis createNumberAxis(Chart ofxChart, OfxChartTypeResolver.AxisOrientation type) {
        Axis ofxAxis = AxisFactory.getAxis(ofxChart, type);
        NumberAxis axis = null;
        switch (OfxChartTypeResolver.getAxisType(ofxAxis.getAxisType())) {
            case Number: {
                axis = AxisFactory.createNumberAxis(ofxAxis);
            }
        }
        return axis;
    }

    public static synchronized NumberAxis createNumberAxis(Axis ofxAxis) {
        AxisType.Number ofxNumberAxis = ofxAxis.getAxisType().getNumber();
        NumberAxis axis = new NumberAxis();
        boolean autoRangeIncludesZero = true;
        if (ofxAxis.isSetAutoRangIncludeNull()) {
            autoRangeIncludesZero = ofxAxis.isAutoRangIncludeNull();
        }
        axis.setAutoRangeIncludesZero(autoRangeIncludesZero);
        logger.debug((Object)("ticker: " + ofxNumberAxis.isSetTicker()));
        if (ofxNumberAxis.isSetTicker() && ofxNumberAxis.getTicker().isSetSize()) {
            logger.debug((Object)("size: " + ofxNumberAxis.getTicker().getSize()));
            axis.setTickUnit(new NumberTickUnit((double)ofxNumberAxis.getTicker().getSize()));
        }
        AxisFactory.labelAxisAxis((org.jfree.chart.axis.Axis)axis, ofxAxis);
        return axis;
    }

    public static synchronized PeriodAxis createPeriodAxis(Axis ofxAxis) {
        AxisType.Date ofxDateAxis = ofxAxis.getAxisType().getDate();
        int level = ofxDateAxis.getTicker().size();
        logger.debug((Object)("Level: " + level));
        PeriodAxis axis = new PeriodAxis(null);
        axis.setAutoRangeTimePeriodClass(Month.class);
        axis.setMajorTickTimePeriodClass(Month.class);
        if (ofxDateAxis.isSetAutoRangeTimePeriod()) {
            axis.setAutoRangeTimePeriodClass(TimePeriodFactory.getPeriodClass(ofxDateAxis.getAutoRangeTimePeriod()));
        }
        if (ofxDateAxis.isSetMajorTickTimePeriod()) {
            axis.setMajorTickTimePeriodClass(TimePeriodFactory.getPeriodClass(ofxDateAxis.getMajorTickTimePeriod()));
        }
        PeriodAxisLabelInfo[] info = new PeriodAxisLabelInfo[level];
        int i = 0;
        for (AxisType.Date.Ticker dt : ofxAxis.getAxisType().getDate().getTicker()) {
            SimpleDateFormat sdf = new SimpleDateFormat(dt.getFormat());
            TimePeriodFactory.OfxChartTimePeriod ofxTp = TimePeriodFactory.OfxChartTimePeriod.valueOf(dt.getTimePeriod());
            switch (ofxTp) {
                case Hour: {
                    info[i] = new PeriodAxisLabelInfo(Hour.class, (DateFormat)sdf);
                    break;
                }
                case Day: {
                    info[i] = new PeriodAxisLabelInfo(Day.class, (DateFormat)sdf);
                    break;
                }
                case Month: {
                    info[i] = new PeriodAxisLabelInfo(Month.class, (DateFormat)sdf);
                    break;
                }
                case Year: {
                    info[i] = new PeriodAxisLabelInfo(Year.class, (DateFormat)sdf);
                }
            }
            ++i;
        }
        axis.setLabelInfo(info);
        AxisFactory.labelAxisAxis((org.jfree.chart.axis.Axis)axis, ofxAxis);
        return axis;
    }

    public static synchronized void labelAxisAxis(org.jfree.chart.axis.Axis axis, Axis ofxAxis) {
        Label ofxLabel;
        if (ofxAxis.isSetLabel() && (ofxLabel = ofxAxis.getLabel()).isSetText()) {
            axis.setLabel(ofxLabel.getText());
            if (ofxLabel.isSetSize() || ofxLabel.isSetFont()) {
                axis.setLabelFont(AxisFactory.createFont(ofxLabel));
            }
        }
    }

    private static synchronized Font createFont(Label ofxLabel) {
        String fontFamily = "SansSerif";
        int fontSize = 10;
        if (ofxLabel.isSetFont()) {
            fontFamily = ofxLabel.getFont();
        }
        if (ofxLabel.isSetSize()) {
            fontSize = ofxLabel.getSize();
        }
        Font font = new Font(fontFamily, 0, fontSize);
        return font;
    }

    private static synchronized Axis getAxis(Chart ofxChart, OfxChartTypeResolver.AxisOrientation type) {
        Axis axisResult = null;
        for (Axis axis : ofxChart.getAxis()) {
            if (!axis.isSetCode() || !axis.getCode().equals(type.toString())) continue;
            axisResult = axis;
        }
        return axisResult;
    }
}

