/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart;

import net.sf.exlp.util.xml.JDomUtil;
import org.jdom.Document;
import org.jfree.chart.JFreeChart;
import org.openfuxml.addon.chart.data.jaxb.Chart;
import org.openfuxml.addon.chart.data.jaxb.Charttype;
import org.openfuxml.addon.chart.renderer.BarChartRenderer;
import org.openfuxml.addon.chart.renderer.TimeBarRenderer;
import org.openfuxml.addon.chart.renderer.gantt.GanttChartRenderer;
import org.openfuxml.addon.chart.renderer.generic.OfxChartRenderer;
import org.openfuxml.addon.chart.renderer.timeseries.AbstractTimeSeriesChartRenderer;
import org.openfuxml.addon.chart.renderer.timeseries.TimeSeriesChartRenderer;
import org.openfuxml.addon.chart.renderer.timeseries.TimeSeriesCumulativeChartRenderer;
import org.openfuxml.addon.chart.renderer.xy.SplineChartRenderer;
import org.openfuxml.addon.chart.util.OfxChartTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFxChartRenderControl {
    static final Logger logger = LoggerFactory.getLogger(OFxChartRenderControl.class);
    private OfxChartRenderer ofxRenderer;

    public JFreeChart render(Chart ofxChart) {
        OfxChartTypeResolver.Type chartType = OfxChartTypeResolver.getType(ofxChart.getCharttype());
        switch (chartType) {
            case TimeSeries: {
                this.ofxRenderer = this.getTimeSeriesRenderer(ofxChart);
                break;
            }
            case TimeBar: {
                this.ofxRenderer = new TimeBarRenderer();
                break;
            }
            case Bar: {
                this.ofxRenderer = new BarChartRenderer();
                break;
            }
            case Gantt: {
                this.ofxRenderer = new GanttChartRenderer();
                break;
            }
            case Spline: {
                this.ofxRenderer = new SplineChartRenderer();
                break;
            }
            default: {
                logger.warn("No Renderer available for " + (Object)((Object)chartType));
            }
        }
        JFreeChart jfreeChart = this.ofxRenderer.render(ofxChart);
        return jfreeChart;
    }

    private OfxChartRenderer getTimeSeriesRenderer(Chart ofxChart) {
        Charttype.Timeseries timeseries = ofxChart.getCharttype().getTimeseries();
        AbstractTimeSeriesChartRenderer result = timeseries.isSetCumulate() && timeseries.isCumulate() ? new TimeSeriesCumulativeChartRenderer() : new TimeSeriesChartRenderer();
        return result;
    }

    public JFreeChart render(Document doc) {
        Chart ofxChart = (Chart)JDomUtil.toJaxb((Document)doc, Chart.class);
        return this.render(ofxChart);
    }

    public OfxChartRenderer getOfxRenderer() {
        return this.ofxRenderer;
    }
}

