/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.generic;

import java.awt.Dimension;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.openfuxml.addon.chart.data.jaxb.Axis;
import org.openfuxml.addon.chart.data.jaxb.Chart;
import org.openfuxml.addon.chart.util.ChartColorFactory;
import org.openfuxml.addon.chart.util.OfxChartTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractChartRenderer {
    static final Logger logger = LoggerFactory.getLogger(AbstractChartRenderer.class);
    protected JFreeChart chart;
    protected Chart ofxChart;

    protected void setColors() {
        this.chart.setBackgroundPaint((Paint)ChartColorFactory.createColor(this.ofxChart, ChartColorFactory.Area.backgroundChart));
        this.chart.getPlot().setBackgroundPaint((Paint)ChartColorFactory.createColor(this.ofxChart, ChartColorFactory.Area.backgroundPlot));
        this.setSpecialColors();
    }

    protected void setSpecialColors() {
        logger.error("This should be @Overridden");
    }

    protected void setGrid() {
        if (this.ofxChart.isSetGrid()) {
            this.setSpecialGrid();
        }
    }

    protected void setSpecialGrid() {
        logger.error("This should be @Overridden");
    }

    protected void setAxis() {
        for (Axis axis : this.ofxChart.getAxis()) {
            OfxChartTypeResolver.AxisOrientation type = OfxChartTypeResolver.AxisOrientation.valueOf(axis.getCode());
            this.setAxis(axis, type);
        }
    }

    protected void setAxis(Axis axis, OfxChartTypeResolver.AxisOrientation type) {
        logger.error("This should be @Overridden");
    }

    public Dimension getSuggestedSize() {
        logger.error("This should be @Overridden");
        throw new UnsupportedOperationException();
    }
}

