/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.timeseries;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.exlp.util.DateUtil;
import org.openfuxml.addon.chart.data.jaxb.Charttype;
import org.openfuxml.addon.chart.data.jaxb.Container;
import org.openfuxml.addon.chart.data.jaxb.Data;
import org.openfuxml.addon.chart.util.TimePeriodFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesGapNullifier {
    static final Logger logger = LoggerFactory.getLogger(TimeSeriesGapNullifier.class);
    int gapUnit;

    public TimeSeriesGapNullifier(TimePeriodFactory.OfxChartTimePeriod timePeriod) {
        switch (timePeriod) {
            case Day: {
                this.gapUnit = 5;
                break;
            }
            case Month: {
                this.gapUnit = 2;
                break;
            }
            default: {
                logger.warn("No gapUnit ... app will crash");
            }
        }
    }

    public Container nullifyGapsInContainer(Container container) {
        ArrayList<Data> lData = new ArrayList<Data>();
        int index = 0;
        int datasetSize = container.getData().size();
        logger.warn("Check size of data.array");
        GregorianCalendar gcBegin = ((Data)container.getData().get(0)).getRecord().toGregorianCalendar();
        GregorianCalendar gcEnd = ((Data)container.getData().get(datasetSize - 1)).getRecord().toGregorianCalendar();
        while (gcBegin.before(gcEnd)) {
            if (index < datasetSize) {
                Data currentData = (Data)container.getData().get(index);
                GregorianCalendar gcCurrent = currentData.getRecord().toGregorianCalendar();
                int compare = gcCurrent.compareTo(gcBegin);
                if (compare == 0) {
                    lData.add(currentData);
                    ++index;
                } else {
                    lData.add(this.createNullData(gcBegin));
                }
            }
            gcBegin.add(this.gapUnit, 1);
        }
        container.getData().clear();
        container.getData().addAll(lData);
        return container;
    }

    private Data createNullData(GregorianCalendar gc) {
        Data d = new Data();
        d.setRecord(DateUtil.getXmlGc4D((Date)gc.getTime()));
        return d;
    }

    public static synchronized boolean gapNullerActivated(Charttype.Timeseries chartTimeSeries) {
        if (chartTimeSeries.isSetGap()) {
            if (chartTimeSeries.isSetTimePeriod()) {
                return chartTimeSeries.isGap();
            }
            logger.warn("chart/charttype/timeseries/@timePeriod is not set!! No GapNulling");
            return false;
        }
        return false;
    }
}

