/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.xy;

import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openfuxml.addon.chart.data.jaxb.Chart;
import org.openfuxml.addon.chart.data.jaxb.Container;
import org.openfuxml.addon.chart.data.jaxb.Data;
import org.openfuxml.addon.chart.renderer.generic.OfxChartRenderer;
import org.openfuxml.addon.chart.renderer.generic.XYPlotRenderer;
import org.openfuxml.addon.chart.renderer.xy.OfxSplineRenderer;
import org.openfuxml.addon.chart.util.AxisFactory;
import org.openfuxml.addon.chart.util.ChartLabelResolver;
import org.openfuxml.addon.chart.util.OfxChartTypeResolver;
import org.openfuxml.addon.chart.util.OfxCustomPaintColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplineChartRenderer
extends XYPlotRenderer
implements OfxChartRenderer {
    static final Logger logger = LoggerFactory.getLogger(SplineChartRenderer.class);
    private Map<Integer, OfxCustomPaintColors> mapOfxColors = new Hashtable<Integer, OfxCustomPaintColors>();
    private Map<Integer, XYSeriesCollection> mapXySeriesCollection;
    private Map<Integer, Integer> mapColorSeriesIndex;

    @Override
    public JFreeChart render(Chart ofxChart) {
        this.ofxChart = ofxChart;
        ValueAxis xAxis = (ValueAxis)AxisFactory.createNumberAxis(ofxChart, OfxChartTypeResolver.AxisOrientation.domain);
        XYPlot plot = new XYPlot();
        plot.setDomainAxis(xAxis);
        this.createDataset3(ofxChart.getContainer());
        for (Integer i : this.mapXySeriesCollection.keySet()) {
            int index = i;
            if (this.mapXySeriesCollection.size() == 1) {
                index = 0;
            }
            OfxSplineRenderer ofxSplineRenderer = new OfxSplineRenderer();
            ofxSplineRenderer.setOfxPaintColors(this.mapOfxColors.get(i));
            plot.setRenderer(index, (XYItemRenderer)ofxSplineRenderer);
            String axisCode = "range" + i;
            OfxChartTypeResolver.AxisOrientation axisOrientation = OfxChartTypeResolver.AxisOrientation.valueOf(axisCode);
            plot.setRangeAxis(index, (ValueAxis)AxisFactory.createNumberAxis(ofxChart, axisOrientation));
            plot.setDataset(index, (XYDataset)this.mapXySeriesCollection.get(i));
            plot.mapDatasetToRangeAxis(index, index);
        }
        this.chart = new JFreeChart(ChartLabelResolver.getTitle(ofxChart), JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, ofxChart.isLegend());
        this.setColors();
        this.setGrid();
        return this.chart;
    }

    protected RegularTimePeriod getRtp(Date d) {
        Hour rtp;
        switch (this.ofxTimePeriod) {
            case Hour: {
                rtp = new Hour(d);
                break;
            }
            case Day: {
                rtp = new Day(d);
                break;
            }
            case Month: {
                rtp = new Month(d);
                break;
            }
            default: {
                rtp = new Hour(d);
            }
        }
        return rtp;
    }

    protected void createDataset3(List<Container> lContainer) {
        this.mapXySeriesCollection = new Hashtable<Integer, XYSeriesCollection>();
        this.mapColorSeriesIndex = new Hashtable<Integer, Integer>();
        int colorIndex = 0;
        for (Container c : lContainer) {
            XYSeries series;
            if (!c.isSetRangeIndex()) {
                c.setRangeIndex(0);
            }
            if (c.isSetData()) {
                logger.info("Container: index=" + this.getColorSeriesIndex(c.getRangeIndex()));
                series = new XYSeries((Comparable)((Object)c.getLabel()));
                for (Data d : c.getData()) {
                    series.add(d.getX(), d.getY());
                }
                this.getXYSeriesCollection(c.getRangeIndex()).addSeries(series);
                int containerColor = c.isSetColorIndex() ? c.getColorIndex() : colorIndex;
                this.getOfxPaintColor(c.getRangeIndex()).addColorMapping(this.getColorSeriesIndex(c.getRangeIndex()), containerColor);
                this.incrementColorSeriesIndex(c.getRangeIndex());
            }
            for (Container c2 : c.getContainer()) {
                if (!c2.isSetRangeIndex()) {
                    c2.setRangeIndex(0);
                }
                if (!c2.isSetData()) continue;
                series = new XYSeries((Comparable)((Object)(c.getLabel() + "-" + c2.getLabel())));
                for (Data d : c2.getData()) {
                    series.add(d.getX(), d.getY());
                }
                this.getXYSeriesCollection(c2.getRangeIndex()).addSeries(series);
                int containerColor = c2.isSetColorIndex() ? c2.getColorIndex() : colorIndex;
                logger.info("color " + containerColor);
                this.getOfxPaintColor(c2.getRangeIndex()).addColorMapping(this.getColorSeriesIndex(c2.getRangeIndex()), containerColor);
                this.incrementColorSeriesIndex(c2.getRangeIndex());
            }
            ++colorIndex;
        }
    }

    private OfxCustomPaintColors getOfxPaintColor(int key) {
        if (!this.mapOfxColors.containsKey(key)) {
            this.mapOfxColors.put(key, new OfxCustomPaintColors());
        }
        return this.mapOfxColors.get(key);
    }

    private XYSeriesCollection getXYSeriesCollection(int key) {
        if (!this.mapXySeriesCollection.containsKey(key)) {
            this.mapXySeriesCollection.put(key, new XYSeriesCollection());
        }
        return this.mapXySeriesCollection.get(key);
    }

    private int getColorSeriesIndex(int key) {
        if (!this.mapColorSeriesIndex.containsKey(key)) {
            this.mapColorSeriesIndex.put(key, 0);
        }
        return this.mapColorSeriesIndex.get(key);
    }

    private void incrementColorSeriesIndex(int key) {
        int index = this.getColorSeriesIndex(key);
        this.mapColorSeriesIndex.put(key, index + 1);
    }
}

