/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.commons.configuration.Configuration;
import org.openfuxml.xml.addon.chart.Chart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOfxChart {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOfxChart.class);
    protected Configuration config;
    protected Chart chart;
    protected List<Chart> charts;
    protected RenderTarget target;
    private String uuid;

    public AbstractOfxChart(Configuration config, RenderTarget target) {
        this.config = config;
        this.target = target;
        this.uuid = UUID.randomUUID().toString();
    }

    protected void loadXmlChartTemplate(String chartFile) throws FileNotFoundException {
        logger.trace("Loading: " + chartFile);
        this.chart = (Chart)JaxbUtil.loadJAXB((String)chartFile, Chart.class);
    }

    public String getUuid() {
        return this.uuid;
    }

    public Chart getChart() {
        return this.chart;
    }

    public List<Chart> getCharts() {
        return this.charts;
    }

    public void addToSession(FacesContext context) {
        HttpSession session = (HttpSession)context.getExternalContext().getSession(true);
        Hashtable<String, Chart> mCharts = (Hashtable<String, Chart>)session.getAttribute("charts");
        if (mCharts == null) {
            mCharts = new Hashtable<String, Chart>();
        }
        mCharts.put(this.uuid, this.chart);
        session.removeAttribute("charts");
        session.setAttribute("charts", mCharts);
    }

    public static enum RenderTarget {
        web,
        pdf;

    }
}

