/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.factory.chart;

import java.util.ArrayList;
import java.util.List;
import org.openfuxml.addon.chart.factory.xml.XmlAxisFactory;
import org.openfuxml.addon.chart.util.TimePeriodFactory;
import org.openfuxml.xml.addon.chart.Axis;
import org.openfuxml.xml.addon.chart.AxisType;
import org.openfuxml.xml.addon.chart.Chart;
import org.openfuxml.xml.addon.chart.Renderer;
import org.openfuxml.xml.addon.chart.RendererTimeseries;

public class TimeSeriesChartFactory {
    private boolean withLegend = false;
    private boolean cumulateValues = false;
    private boolean withGaps = false;
    private boolean sumDate = true;
    private boolean orderRecords = false;
    private TimePeriodFactory.OfxChartTimePeriod timePeriod;

    public void setOrderRecords(boolean orderRecords) {
        this.orderRecords = orderRecords;
    }

    public Chart build() {
        Chart chart = new Chart();
        chart.setLegend(this.withLegend);
        chart.setRenderer(this.buildRenderer());
        chart.getAxis().addAll(this.buildAxis());
        return chart;
    }

    private Renderer buildRenderer() {
        Renderer renderer = new Renderer();
        RendererTimeseries timeSeriesRenderer = new RendererTimeseries();
        timeSeriesRenderer.setGap(this.withGaps);
        timeSeriesRenderer.setCumulate(this.cumulateValues);
        timeSeriesRenderer.setSumDate(this.sumDate);
        timeSeriesRenderer.setOrderRecords(this.orderRecords);
        if (this.timePeriod != null) {
            timeSeriesRenderer.setTimePeriod(this.timePeriod.toString());
        }
        renderer.setRendererTimeseries(timeSeriesRenderer);
        return renderer;
    }

    private List<Axis> buildAxis() {
        ArrayList<Axis> list = new ArrayList<Axis>();
        AxisType.Date.Ticker t1 = new AxisType.Date.Ticker();
        t1.setFormat("MMM");
        t1.setTimePeriod("Month");
        AxisType.Date.Ticker t2 = new AxisType.Date.Ticker();
        t2.setFormat("yyyy");
        t2.setTimePeriod("Year");
        AxisType.Date date = new AxisType.Date();
        date.setAutoRangeTimePeriod("Month");
        date.setMajorTickTimePeriod("Year");
        date.getTicker().add(t1);
        date.getTicker().add(t2);
        AxisType type = new AxisType();
        type.setDate(date);
        Axis axis = XmlAxisFactory.build(XmlAxisFactory.Orientation.domain);
        axis.setAxisType(type);
        list.add(axis);
        return list;
    }

    public void setWithLegend(boolean withLegend) {
        this.withLegend = withLegend;
    }

    public void setCumulateValues(boolean cumulateValues) {
        this.cumulateValues = cumulateValues;
    }

    public void setWithGaps(boolean withGaps) {
        this.withGaps = withGaps;
    }

    public void setSumDate(boolean sumDate) {
        this.sumDate = sumDate;
    }

    public void setTimePeriod(TimePeriodFactory.OfxChartTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
    }
}

