/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer;

import java.util.Date;
import java.util.List;
import net.sf.exlp.util.DateUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.openfuxml.addon.chart.interfaces.ChartRenderer;
import org.openfuxml.addon.chart.renderer.generic.XYPlotRenderer;
import org.openfuxml.addon.chart.util.ChartLabelResolver;
import org.openfuxml.xml.addon.chart.Chart;
import org.openfuxml.xml.addon.chart.Data;
import org.openfuxml.xml.addon.chart.DataSet;
import org.openfuxml.xml.addon.chart.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBarRenderer
extends XYPlotRenderer
implements ChartRenderer {
    static final Logger logger = LoggerFactory.getLogger(TimeBarRenderer.class);

    public TimeBarRenderer() {
        logger.debug("Active");
    }

    @Override
    public JFreeChart render(Chart ofxChart) {
        this.ofxChart = ofxChart;
        Renderer.Timebar timebar = ofxChart.getRenderer().getTimebar();
        this.chart = ChartFactory.createXYBarChart((String)ChartLabelResolver.getTitle(ofxChart), (String)ChartLabelResolver.getAxisLabelX(ofxChart), (boolean)true, (String)ChartLabelResolver.getAxisLabelY(ofxChart), (IntervalXYDataset)this.createDataset(ofxChart.getDataSet()), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)ofxChart.isLegend(), (boolean)true, (boolean)false);
        this.setColors();
        this.setGrid();
        XYPlot plot = (XYPlot)this.chart.getPlot();
        ClusteredXYBarRenderer renderer = new ClusteredXYBarRenderer(0.0, false);
        if (timebar.isSetShadow()) {
            renderer.setShadowVisible(timebar.isShadow());
        }
        if (timebar.isSetGradient() && timebar.isGradient()) {
            renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        }
        renderer.setDrawBarOutline(false);
        plot.setRenderer((XYItemRenderer)renderer);
        return this.chart;
    }

    private IntervalXYDataset createDataset(List<DataSet> lContainer) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (DataSet container : lContainer) {
            TimeSeries ts = new TimeSeries((Comparable)((Object)container.getLabel()));
            for (Data data : container.getData()) {
                Date d = DateUtil.getDateFromInt((int)data.getRecord().getYear(), (int)data.getRecord().getMonth(), (int)data.getRecord().getDay());
                ts.addOrUpdate((RegularTimePeriod)new Hour(d), data.getY());
            }
            dataset.addSeries(ts);
        }
        return dataset;
    }
}

