/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.gantt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.exlp.util.DateUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.gantt.XYTaskDataset;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.xy.IntervalXYDataset;
import org.openfuxml.addon.chart.interfaces.ChartRenderer;
import org.openfuxml.addon.chart.renderer.gantt.ColorTaskGradientXYBarPainter;
import org.openfuxml.addon.chart.renderer.gantt.ColorTaskXYBarRenderer;
import org.openfuxml.addon.chart.renderer.generic.XYPlotRenderer;
import org.openfuxml.addon.chart.util.ChartColorFactory;
import org.openfuxml.addon.chart.util.ChartLabelResolver;
import org.openfuxml.xml.addon.chart.Chart;
import org.openfuxml.xml.addon.chart.Data;
import org.openfuxml.xml.addon.chart.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GanttChartRenderer
extends XYPlotRenderer
implements ChartRenderer {
    static final Logger logger = LoggerFactory.getLogger(GanttChartRenderer.class);

    @Override
    public JFreeChart render(Chart ofxChart) {
        this.ofxChart = ofxChart;
        this.setTimePeriod();
        XYTaskDataset dataset = new XYTaskDataset(this.createTasks(ofxChart.getDataSet()));
        this.chart = ChartFactory.createXYBarChart((String)ChartLabelResolver.getTitle(ofxChart), (String)ChartLabelResolver.getAxisLabelY(ofxChart), (boolean)false, (String)ChartLabelResolver.getAxisLabelX(ofxChart), (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)ofxChart.isLegend(), (boolean)false, (boolean)false);
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.setTaskNames();
        Map<String, Color> colorMap = ChartColorFactory.getColorMap(ofxChart.getColors(), "task");
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setRenderer((XYItemRenderer)new ColorTaskXYBarRenderer(colorMap));
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setUseYInterval(true);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((XYBarPainter)new ColorTaskGradientXYBarPainter());
        this.setAxis();
        this.setColors();
        this.setGrid();
        return this.chart;
    }

    private void setTaskNames() {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        String[] taskNames = new String[this.ofxChart.getDataSet().size()];
        int i = 0;
        for (DataSet c : this.ofxChart.getDataSet()) {
            taskNames[i] = c.getLabel();
            ++i;
        }
        SymbolAxis yAxis = new SymbolAxis(ChartLabelResolver.getAxisLabelY(this.ofxChart), taskNames);
        yAxis.setGridBandsVisible(true);
        plot.setDomainAxis((ValueAxis)yAxis);
        plot.setDomainAxis((ValueAxis)yAxis);
    }

    private TaskSeriesCollection createTasksDummy() {
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        TaskSeries s1 = new TaskSeries("Team A");
        Date from = DateUtil.getDateFromInt((int)2010, (int)1, (int)1);
        Date to = DateUtil.getDateFromInt((int)2010, (int)1, (int)15);
        SimpleTimePeriod stp = new SimpleTimePeriod(from, to);
        s1.add(new Task("na", (TimePeriod)stp));
        dataset.add(s1);
        TaskSeries s4 = new TaskSeries("Team D");
        from = DateUtil.getDateFromInt((int)2010, (int)1, (int)1);
        to = DateUtil.getDateFromInt((int)2010, (int)1, (int)15);
        stp = new SimpleTimePeriod(from, to);
        s4.add(new Task("na", (TimePeriod)stp));
        from = DateUtil.getDateFromInt((int)2010, (int)1, (int)17);
        to = DateUtil.getDateFromInt((int)2010, (int)1, (int)21);
        stp = new SimpleTimePeriod(from, to);
        s4.add(new Task("holiday", (TimePeriod)stp));
        dataset.add(s4);
        return dataset;
    }

    private TaskSeriesCollection createTasks(List<DataSet> container) {
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        for (DataSet c : container) {
            TaskSeries ts = new TaskSeries(c.getLabel());
            for (Data d : c.getData()) {
                Date from = DateUtil.getDate4XmlGc((XMLGregorianCalendar)d.getFrom());
                Date to = DateUtil.getDate4XmlGc((XMLGregorianCalendar)d.getTo());
                SimpleTimePeriod stp = new SimpleTimePeriod(from, to);
                Task t = new Task(d.getCategory(), (TimePeriod)stp);
                ts.add(t);
            }
            dataset.add(ts);
        }
        return dataset;
    }

    @Override
    public Dimension getSuggestedSize() {
        Dimension d = new Dimension();
        d.setSize(0, 75 + this.ofxChart.getDataSet().size() * 25);
        return d;
    }
}

