/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.generic;

import java.awt.Paint;
import net.sf.exlp.util.xml.JaxbUtil;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.openfuxml.addon.chart.renderer.generic.AbstractChartRenderer;
import org.openfuxml.addon.chart.util.AxisFactory;
import org.openfuxml.addon.chart.util.ChartColorFactory;
import org.openfuxml.addon.chart.util.OfxChartTypeResolver;
import org.openfuxml.addon.chart.util.TimePeriodFactory;
import org.openfuxml.xml.addon.chart.Grid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XYPlotRenderer
extends AbstractChartRenderer {
    static final Logger logger = LoggerFactory.getLogger(XYPlotRenderer.class);
    protected TimePeriodFactory.OfxChartTimePeriod ofxTimePeriod;

    @Override
    protected void setSpecialColors() {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setRangeGridlinePaint((Paint)ChartColorFactory.createColor(this.ofxChart, ChartColorFactory.Area.gridRange));
        plot.setDomainGridlinePaint((Paint)ChartColorFactory.createColor(this.ofxChart, ChartColorFactory.Area.gridDomain));
    }

    @Override
    protected void setSpecialGrid() {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        Grid grid = this.ofxChart.getGrid();
        if (grid.isSetDomain()) {
            plot.setDomainGridlinesVisible(grid.isDomain());
        }
        if (grid.isSetRange()) {
            plot.setRangeGridlinesVisible(grid.isRange());
        }
    }

    protected void setTimePeriod() {
        if (this.ofxChart.getRenderer().isSetRendererTimeseries() && this.ofxChart.getRenderer().getRendererTimeseries().isSetTimePeriod()) {
            logger.debug("checking=" + this.ofxChart.getRenderer().getRendererTimeseries().getTimePeriod());
            try {
                this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.valueOf(this.ofxChart.getRenderer().getRendererTimeseries().getTimePeriod());
            }
            catch (IllegalArgumentException e) {
                logger.error("timePeriod " + this.ofxChart.getRenderer().getRendererTimeseries().getTimePeriod() + " is not valid, using Hour as default");
                this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.Hour;
            }
        } else if (this.ofxChart.getRenderer().isSetGantt() && this.ofxChart.getRenderer().getGantt().isSetTimePeriod()) {
            this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.valueOf(this.ofxChart.getRenderer().getGantt().getTimePeriod());
        } else {
            logger.warn("chart/charttype/timeseries/@timePeriod is not set!!");
            logger.warn("Using default: Hour");
            this.ofxTimePeriod = TimePeriodFactory.OfxChartTimePeriod.Hour;
        }
    }

    @Override
    protected void setAxis(org.openfuxml.xml.addon.chart.Axis ofxAxis, OfxChartTypeResolver.AxisOrientation axisOrientation) {
        logger.info("Setting axis");
        JaxbUtil.trace((Object)ofxAxis);
        NumberAxis axis = null;
        switch (OfxChartTypeResolver.getAxisType(ofxAxis.getAxisType())) {
            case Number: {
                axis = AxisFactory.createNumberAxis(ofxAxis);
                break;
            }
            case Date: {
                axis = AxisFactory.createPeriodAxis(ofxAxis);
                break;
            }
            default: {
                logger.warn("You should specify a type, defaulting to number");
                axis = new NumberAxis();
                AxisFactory.labelAxisAxis((Axis)axis, ofxAxis);
            }
        }
        if (axis != null) {
            XYPlot plot = (XYPlot)this.chart.getPlot();
            switch (OfxChartTypeResolver.AxisOrientation.valueOf(ofxAxis.getCode())) {
                case domain: {
                    plot.setDomainAxis((ValueAxis)axis);
                    break;
                }
                case range0: {
                    plot.setRangeAxis((ValueAxis)axis);
                    break;
                }
                default: {
                    logger.warn("NYI");
                }
            }
        }
    }
}

