/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.renderer.timeseries;

import java.util.Date;
import java.util.List;
import net.sf.exlp.util.DateUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.openfuxml.addon.chart.interfaces.ChartRenderer;
import org.openfuxml.addon.chart.processor.DataSetCumulator;
import org.openfuxml.addon.chart.processor.TimeSeriesGapNullifier;
import org.openfuxml.addon.chart.processor.timeseries.TimeSeriesDateSummer;
import org.openfuxml.addon.chart.processor.timeseries.TimeSeriesRecordOrderer;
import org.openfuxml.addon.chart.renderer.generic.XYPlotRenderer;
import org.openfuxml.addon.chart.util.ChartLabelResolver;
import org.openfuxml.addon.chart.util.TimePeriodFactory;
import org.openfuxml.xml.addon.chart.Chart;
import org.openfuxml.xml.addon.chart.Data;
import org.openfuxml.xml.addon.chart.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesChartRenderer
extends XYPlotRenderer
implements ChartRenderer {
    static final Logger logger = LoggerFactory.getLogger(TimeSeriesChartRenderer.class);

    public TimeSeriesChartRenderer() {
        logger.debug("Using: " + this.getClass().getSimpleName());
    }

    @Override
    public JFreeChart render(Chart ofxChart) {
        this.ofxChart = ofxChart;
        this.setTimePeriod();
        this.chart = ChartFactory.createTimeSeriesChart((String)ChartLabelResolver.getTitle(ofxChart), null, null, (XYDataset)this.createDataset(ofxChart.getDataSet()), (boolean)ofxChart.isLegend(), (boolean)true, (boolean)false);
        this.setColors();
        this.setGrid();
        this.setAxis();
        return this.chart;
    }

    protected RegularTimePeriod getRtp(Date d) {
        Hour rtp;
        switch (this.ofxTimePeriod) {
            case Hour: {
                rtp = new Hour(d);
                break;
            }
            case Day: {
                rtp = new Day(d);
                break;
            }
            case Month: {
                rtp = new Month(d);
                break;
            }
            default: {
                rtp = new Hour(d);
            }
        }
        return rtp;
    }

    private TimeSeriesCollection createDataset(List<DataSet> dataSets) {
        TimeSeriesDateSummer dateSummer = TimeSeriesDateSummer.factory(this.ofxChart.getRenderer().getRendererTimeseries());
        TimeSeriesRecordOrderer recordOrderer = TimeSeriesRecordOrderer.factory(this.ofxChart.getRenderer().getRendererTimeseries());
        DataSetCumulator cumulator = DataSetCumulator.factory(this.ofxChart.getRenderer().getRendererTimeseries());
        TimeSeriesGapNullifier gapNuller = null;
        boolean nullifyGaps = TimeSeriesGapNullifier.gapNullerActivated(this.ofxChart.getRenderer().getRendererTimeseries());
        if (nullifyGaps) {
            TimePeriodFactory.OfxChartTimePeriod timePeriod = TimePeriodFactory.OfxChartTimePeriod.valueOf(this.ofxChart.getRenderer().getRendererTimeseries().getTimePeriod());
            gapNuller = new TimeSeriesGapNullifier(timePeriod);
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (DataSet dataSet : dataSets) {
            dataSet = recordOrderer.process(dataSet);
            dataSet = dateSummer.process(dataSet);
            dataSet = cumulator.process(dataSet);
            if (nullifyGaps) {
                dataSet = gapNuller.nullifyGapsInContainer(dataSet);
            }
            TimeSeries ts = new TimeSeries((Comparable)((Object)dataSet.getLabel()));
            for (Data data : dataSet.getData()) {
                Date d = DateUtil.getDateFromInt((int)data.getRecord().getYear(), (int)data.getRecord().getMonth(), (int)data.getRecord().getDay());
                RegularTimePeriod rtp = this.getRtp(d);
                if (data.isSetY()) {
                    ts.addOrUpdate(rtp, data.getY());
                    continue;
                }
                ts.addOrUpdate(rtp, null);
            }
            dataset.addSeries(ts);
            logger.info("Add here TS with same color from container");
        }
        return dataset;
    }
}

