/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.util;

import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.Year;
import org.openfuxml.addon.chart.util.OfxChartTypeResolver;
import org.openfuxml.addon.chart.util.TimePeriodFactory;
import org.openfuxml.xml.addon.chart.AxisType;
import org.openfuxml.xml.addon.chart.Chart;
import org.openfuxml.xml.addon.chart.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxisFactory {
    static final Logger logger = LoggerFactory.getLogger(AxisFactory.class);

    public static synchronized Axis createNumberAxis(Chart ofxChart, OfxChartTypeResolver.AxisOrientation type) {
        org.openfuxml.xml.addon.chart.Axis ofxAxis = AxisFactory.getAxis(ofxChart, type);
        NumberAxis axis = null;
        switch (OfxChartTypeResolver.getAxisType(ofxAxis.getAxisType())) {
            case Number: {
                axis = AxisFactory.createNumberAxis(ofxAxis);
            }
        }
        return axis;
    }

    public static synchronized NumberAxis createNumberAxis(org.openfuxml.xml.addon.chart.Axis ofxAxis) {
        AxisType.Number ofxNumberAxis = ofxAxis.getAxisType().getNumber();
        NumberAxis axis = new NumberAxis();
        boolean autoRangeIncludesZero = true;
        if (ofxAxis.isSetAutoRangIncludeNull()) {
            autoRangeIncludesZero = ofxAxis.isAutoRangIncludeNull();
        }
        axis.setAutoRangeIncludesZero(autoRangeIncludesZero);
        logger.debug("ticker: " + ofxNumberAxis.isSetTicker());
        if (ofxNumberAxis.isSetTicker() && ofxNumberAxis.getTicker().isSetSize()) {
            logger.debug("size: " + ofxNumberAxis.getTicker().getSize());
            axis.setTickUnit(new NumberTickUnit((double)ofxNumberAxis.getTicker().getSize()));
        }
        AxisFactory.labelAxisAxis((Axis)axis, ofxAxis);
        return axis;
    }

    public static synchronized PeriodAxis createPeriodAxis(org.openfuxml.xml.addon.chart.Axis ofxAxis) {
        AxisType.Date ofxDateAxis = ofxAxis.getAxisType().getDate();
        int level = ofxDateAxis.getTicker().size();
        logger.debug("Level: " + level);
        PeriodAxis axis = new PeriodAxis(null);
        axis.setAutoRangeTimePeriodClass(Month.class);
        axis.setMajorTickTimePeriodClass(Month.class);
        if (ofxDateAxis.isSetAutoRangeTimePeriod()) {
            axis.setAutoRangeTimePeriodClass(TimePeriodFactory.getPeriodClass(ofxDateAxis.getAutoRangeTimePeriod()));
        }
        if (ofxDateAxis.isSetMajorTickTimePeriod()) {
            axis.setMajorTickTimePeriodClass(TimePeriodFactory.getPeriodClass(ofxDateAxis.getMajorTickTimePeriod()));
        }
        PeriodAxisLabelInfo[] info = new PeriodAxisLabelInfo[level];
        int i = 0;
        for (AxisType.Date.Ticker dt : ofxAxis.getAxisType().getDate().getTicker()) {
            SimpleDateFormat sdf = new SimpleDateFormat(dt.getFormat());
            TimePeriodFactory.OfxChartTimePeriod ofxTp = TimePeriodFactory.OfxChartTimePeriod.valueOf(dt.getTimePeriod());
            switch (ofxTp) {
                case Hour: {
                    info[i] = new PeriodAxisLabelInfo(Hour.class, (DateFormat)sdf);
                    break;
                }
                case Day: {
                    info[i] = new PeriodAxisLabelInfo(Day.class, (DateFormat)sdf);
                    break;
                }
                case Month: {
                    info[i] = new PeriodAxisLabelInfo(Month.class, (DateFormat)sdf);
                    break;
                }
                case Year: {
                    info[i] = new PeriodAxisLabelInfo(Year.class, (DateFormat)sdf);
                }
            }
            ++i;
        }
        axis.setLabelInfo(info);
        AxisFactory.labelAxisAxis((Axis)axis, ofxAxis);
        return axis;
    }

    public static synchronized void labelAxisAxis(Axis axis, org.openfuxml.xml.addon.chart.Axis ofxAxis) {
        Label ofxLabel;
        if (ofxAxis.isSetLabel() && (ofxLabel = ofxAxis.getLabel()).isSetText()) {
            axis.setLabel(ofxLabel.getText());
            if (ofxLabel.isSetSize() || ofxLabel.isSetFont()) {
                axis.setLabelFont(AxisFactory.createFont(ofxLabel));
            }
        }
    }

    private static synchronized Font createFont(Label ofxLabel) {
        String fontFamily = "SansSerif";
        int fontSize = 10;
        if (ofxLabel.isSetFont()) {
            fontFamily = ofxLabel.getFont();
        }
        if (ofxLabel.isSetSize()) {
            fontSize = ofxLabel.getSize();
        }
        Font font = new Font(fontFamily, 0, fontSize);
        return font;
    }

    private static synchronized org.openfuxml.xml.addon.chart.Axis getAxis(Chart ofxChart, OfxChartTypeResolver.AxisOrientation type) {
        org.openfuxml.xml.addon.chart.Axis axisResult = null;
        for (org.openfuxml.xml.addon.chart.Axis axis : ofxChart.getAxis()) {
            if (!axis.isSetCode() || !axis.getCode().equals(type.toString())) continue;
            axisResult = axis;
        }
        return axisResult;
    }
}

