/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.chart.util;

import java.util.Date;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePeriodFactory {
    static final Logger logger = LoggerFactory.getLogger(TimePeriodFactory.class);

    public static synchronized RegularTimePeriod getRtp(OfxChartTimePeriod ofxTimePeriod, Date d) {
        Hour rtp;
        switch (ofxTimePeriod) {
            case Hour: {
                rtp = new Hour(d);
                break;
            }
            case Day: {
                rtp = new Day(d);
                break;
            }
            case Month: {
                rtp = new Month(d);
                break;
            }
            default: {
                rtp = new Hour(d);
            }
        }
        return rtp;
    }

    public static synchronized Class<?> getPeriodClass(String value) {
        Class<Hour> c = null;
        switch (TimePeriodFactory.getOfxTimePeriod(value)) {
            case Hour: {
                c = Hour.class;
                break;
            }
            case Day: {
                c = Day.class;
                break;
            }
            case Month: {
                c = Month.class;
                break;
            }
            case Year: {
                c = Year.class;
                break;
            }
            default: {
                c = Day.class;
            }
        }
        return c;
    }

    private static synchronized OfxChartTimePeriod getOfxTimePeriod(String value) {
        return OfxChartTimePeriod.valueOf(value);
    }

    public static enum OfxChartTimePeriod {
        Hour,
        Day,
        Month,
        Year;

    }
}

