/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.doc.provider.table;

import java.util.ArrayList;
import java.util.List;
import org.openfuxml.content.layout.Width;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.content.ofx.Title;
import org.openfuxml.content.table.Column;
import org.openfuxml.content.table.Columns;
import org.openfuxml.content.table.Specification;
import org.openfuxml.content.table.Table;
import org.openfuxml.doc.provider.DemoContentProvider;
import org.openfuxml.factory.xml.layout.XmlAlignmentFactory;
import org.openfuxml.factory.xml.ofx.content.structure.XmlSectionFactory;
import org.openfuxml.factory.xml.table.XmlColumnFactory;
import org.openfuxml.factory.xml.table.XmlTableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableProvider {
    static final Logger logger = LoggerFactory.getLogger(TableProvider.class);

    public static Section build() {
        Section xml = XmlSectionFactory.build();
        xml.getContent().add(TableProvider.create());
        return xml;
    }

    public static Section build(int col, int row) {
        Section xml = XmlSectionFactory.build();
        xml.getContent().add(TableProvider.create(col, row));
        return xml;
    }

    public static Section buildWithoutSpecification() {
        Section xml = XmlSectionFactory.build();
        xml.getContent().add(TableProvider.createSimple());
        return xml;
    }

    public static Section buildWithoutSpecification(int col, int row) {
        Section xml = XmlSectionFactory.build();
        xml.getContent().add(TableProvider.createSimple(col, row));
        return xml;
    }

    public static Table createSimple() {
        return TableProvider.createSimple(4, 2, 1);
    }

    public static Table createSimple(int col, int row) {
        return TableProvider.createSimple(4, col, row);
    }

    private static Table createSimple(int words, int col, int row) {
        Table xml = XmlTableFactory.build(TableProvider.createHead(col), TableProvider.createBody(words, col, row));
        xml.setTitle(TableProvider.title());
        xml.setId(DemoContentProvider.li.getWords(words - 3, words + 2));
        return xml;
    }

    public static Table create() {
        return TableProvider.create(4, 2, 1);
    }

    public static Table create(int col, int row) {
        return TableProvider.create(4, col, row);
    }

    private static Table create(int words, int col, int row) {
        Table xml = XmlTableFactory.build(TableProvider.createHead(col), TableProvider.createBody(words, col, row));
        xml.setTitle(TableProvider.title());
        xml.setSpecification(TableProvider.specifications());
        xml.setId(DemoContentProvider.li.getWords(words - 3, words + 2));
        return xml;
    }

    private static List<String> createHead(int col) {
        ArrayList<String> h = new ArrayList<String>();
        while (col > 0) {
            h.add("Column" + col--);
        }
        return h;
    }

    private static List<Object[]> createBody(int words, int col, int row) {
        ArrayList<Object[]> b = new ArrayList<Object[]>();
        while (row > 0) {
            int c = col;
            String[] data = new String[col];
            while (c > 0) {
                data[--c] = DemoContentProvider.li.getWords(words);
            }
            b.add(data);
            --row;
        }
        return b;
    }

    private static Specification specifications() {
        Columns c = new Columns();
        XmlColumnFactory.add((Columns)c, (XmlAlignmentFactory.Horizontal)XmlAlignmentFactory.Horizontal.center);
        c.getColumn().add(XmlColumnFactory.percentage((double)55.0));
        XmlColumnFactory.add((Columns)c, (XmlAlignmentFactory.Horizontal)XmlAlignmentFactory.Horizontal.right);
        Width w = new Width();
        w.setValue(30.0);
        w.setUnit("percentage");
        ((Column)c.getColumn().get(2)).setWidth(w);
        Specification spezi = new Specification();
        spezi.setColumns(c);
        return spezi;
    }

    private static Title title() {
        Title t = new Title();
        t.getContent().add(DemoContentProvider.li.getWords(3));
        return t;
    }
}

