/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki;

import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.openfuxml.addon.wiki.data.jaxb.MarkupProcessor;
import org.openfuxml.addon.wiki.data.jaxb.Templates;
import org.openfuxml.addon.wiki.data.jaxb.XhtmlProcessor;
import org.openfuxml.addon.wiki.processor.markup.WikiMarkupProcessor;
import org.openfuxml.addon.wiki.processor.markup.WikiModelProcessor;
import org.openfuxml.addon.wiki.processor.ofx.xml.WikiPageProcessor;
import org.openfuxml.addon.wiki.processor.xhtml.XhtmlFinalProcessor;
import org.openfuxml.addon.wiki.processor.xhtml.XhtmlReplaceProcessor;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.exception.OfxConfigurationException;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.openfuxml.xml.renderer.cmp.Cmp;

public class WikiInlineProcessor {
    static Log logger = LogFactory.getLog(WikiInlineProcessor.class);
    public static boolean debugOutput = false;
    private WikiMarkupProcessor wpMarkup;
    private WikiModelProcessor wpModel;
    private XhtmlReplaceProcessor wpXhtmlR;
    private XhtmlFinalProcessor wpXhtmlF;
    private WikiPageProcessor ofxP;

    public WikiInlineProcessor(Cmp cmp) throws OfxConfigurationException {
        MarkupProcessor mpXml = cmp.getPreprocessor().getWiki().getMarkupProcessor();
        XhtmlProcessor xpXml = cmp.getPreprocessor().getWiki().getXhtmlProcessor();
        Templates templates = cmp.getPreprocessor().getWiki().getTemplates();
        this.wpMarkup = new WikiMarkupProcessor(mpXml.getReplacements(), mpXml.getInjections(), templates);
        this.wpModel = new WikiModelProcessor();
        this.wpXhtmlR = new XhtmlReplaceProcessor(xpXml.getReplacements());
        this.wpXhtmlF = new XhtmlFinalProcessor();
        this.ofxP = new WikiPageProcessor();
    }

    public Section toOfx(String wikiPlain) throws OfxInternalProcessingException {
        if (debugOutput) {
            logger.debug((Object)("wikiPlain: " + wikiPlain));
        }
        String wikiMarkup = this.wpMarkup.process(wikiPlain, "ARTICLE ... ");
        if (debugOutput) {
            logger.debug((Object)("wikiMarkup: " + wikiMarkup));
        }
        String xhtmlModel = this.wpModel.process(wikiMarkup);
        if (debugOutput) {
            logger.debug((Object)("xhtmlModel: " + xhtmlModel));
        }
        String xhtmlReplace = this.wpXhtmlR.process(xhtmlModel);
        if (debugOutput) {
            logger.debug((Object)("xhtmlReplace: " + xhtmlReplace));
        }
        String xhtmlFinal = this.wpXhtmlF.process(xhtmlReplace);
        if (debugOutput) {
            logger.debug((Object)("xhtmlFinal: " + xhtmlFinal));
        }
        Element xml = this.ofxP.process(xhtmlFinal);
        if (debugOutput) {
            logger.debug((Object)JaxbUtil.toString((Object)xml));
        }
        Section section = (Section)JDomUtil.toJaxb((Element)xml, Section.class);
        return section;
    }
}

