/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.emitter;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.addon.wiki.processor.ofx.EmitterFactory;
import org.openfuxml.addon.wiki.processor.ofx.emitter.SimpleMappingEmitter;
import org.xml.sax.Attributes;

public class BookEmitter
extends SimpleMappingEmitter {
    private String bookTitle;

    public BookEmitter(EmitterFactory ef) {
        super(ef, "book");
    }

    @Override
    public boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        boolean ok = super.localStart(writer, htmlElementName, atts);
        if (ok && this.bookTitle != null) {
            writer.writeStartElement("title");
            writer.writeCharacters(this.bookTitle);
            writer.writeEndElement();
        }
        return ok;
    }

    @Override
    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        HashMap acronyms = new HashMap();
        if (!acronyms.isEmpty()) {
            writer.writeStartElement("appendix");
            writer.writeAttribute("id", "glossary");
            writer.writeStartElement("title");
            writer.writeAttribute("id", "glossary-end");
            writer.writeCharacters("Glossary");
            writer.writeEndElement();
            writer.writeStartElement("glosslist");
            for (Map.Entry glossEntry : new TreeMap(acronyms).entrySet()) {
                writer.writeStartElement("glossentry");
                writer.writeStartElement("glossterm");
                writer.writeCharacters((String)glossEntry.getKey());
                writer.writeEndElement();
                writer.writeStartElement("glossdef");
                writer.writeStartElement("para");
                writer.writeCharacters((String)glossEntry.getValue());
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        return super.localEnd(writer, htmlElementName);
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    @Override
    protected boolean permitsMultipleNexting() {
        return true;
    }
}

