/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.media.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.exlp.util.io.ConfigLoader;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.io.resourceloader.MultiResourceLoader;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.openfuxml.addon.wiki.data.jaxb.Ofxchart;
import org.openfuxml.addon.wiki.media.chart.factory.BarChartFactory;
import org.openfuxml.addon.wiki.util.WikiConfigChecker;

public class ChartRenderer {
    static Log logger = LogFactory.getLog(ChartRenderer.class);
    private MultiResourceLoader mrl;
    private Configuration config;
    private String chartName;
    private Ofxchart ofxChart;
    private int width;
    private int height;

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public ChartRenderer(Configuration config) {
        this.config = config;
        this.chartName = "you-forgot-to-set-a-chart-name";
        this.mrl = new MultiResourceLoader();
        this.width = 400;
        this.height = 300;
    }

    public void loadChart(String fileName) {
        this.ofxChart = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Ofxchart.class});
            Unmarshaller u = jc.createUnmarshaller();
            this.ofxChart = (Ofxchart)u.unmarshal(this.mrl.searchIs(fileName));
        }
        catch (JAXBException e) {
            logger.error((Object)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
    }

    public void applyChart(Ofxchart ofxChart) {
        this.ofxChart = ofxChart;
    }

    public void render() {
        logger.debug((Object)this.ofxChart.getType());
        BarChartFactory bcf = new BarChartFactory();
        JFreeChart chart = bcf.createChart(this.ofxChart);
        this.save(chart);
    }

    private void save(JFreeChart chart) {
        this.savePNG(chart);
        this.saveEPS(chart);
    }

    private void savePNG(JFreeChart chart) {
        File f = new File(this.config.getString("/ofx/dir[@type='image-web']") + "/" + this.chartName + ".png");
        try {
            FileOutputStream os = new FileOutputStream(f);
            ChartUtilities.writeChartAsPNG((OutputStream)os, (JFreeChart)chart, (int)this.width, (int)this.height);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private void saveEPS(JFreeChart chart) {
        File f = new File(this.config.getString("/ofx/dir[@type='image-eps']") + "/" + this.chartName + ".eps");
        try {
            EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
            g2d.setGraphicContext(new GraphicContext());
            FileOutputStream out = new FileOutputStream(f);
            g2d.setupDocument((OutputStream)out, this.width, this.height);
            chart.draw((Graphics2D)g2d, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
            g2d.finish();
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        ConfigLoader.add((String)"resources/config/wiki/wiki.xml");
        Configuration config = ConfigLoader.init();
        WikiConfigChecker.check(config);
        ChartRenderer cr = new ChartRenderer(config);
        cr.loadChart("resources/data/timeline-ofxchart.xml");
        cr.render();
    }
}

