/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.media.chart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openfuxml.addon.wiki.data.jaxb.Ofxchart;

public class ChartXmlUtil {
    static Log logger = LogFactory.getLog(ChartXmlUtil.class);

    public static synchronized Document loadChart(Ofxchart ofxChart) {
        Document doc = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Ofxchart.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)ofxChart, (OutputStream)out);
            ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
            doc = new SAXBuilder().build((InputStream)is);
            doc.setRootElement(ChartXmlUtil.unsetNameSpace(doc.getRootElement()));
        }
        catch (JAXBException e) {
            logger.error((Object)e);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return doc;
    }

    private static synchronized Element unsetNameSpace(Element e) {
        e.setNamespace(null);
        for (Object o : e.getChildren()) {
            Element eChild = (Element)o;
            Element element = ChartXmlUtil.unsetNameSpace(eChild);
        }
        return e;
    }
}

