/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.exlp.event.LogEvent;
import net.sf.exlp.event.LogEventHandler;
import net.sf.exlp.event.handler.EhDebug;
import net.sf.exlp.listener.impl.LogListenerXml;
import net.sf.exlp.parser.AbstractLogParser;
import net.sf.exlp.parser.LogParser;
import net.sf.exlp.util.io.LoggerInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.data.jaxb.Ofxgallery;
import org.openfuxml.addon.wiki.event.WikiImageEvent;

public class WikiGalleryParser
extends AbstractLogParser
implements LogParser {
    static Log logger = LogFactory.getLog(WikiGalleryParser.class);
    private ArrayList<Pattern> alP = new ArrayList();

    public WikiGalleryParser(LogEventHandler leh) {
        super(leh);
        this.alP.add(Pattern.compile("[ ]*Bild:([&\\w\\s\\.]+)\\|(.*)"));
    }

    public void parseLine(String line) {
        ++this.allLines;
        boolean unknownPattern = true;
        for (int i = 0; i < this.alP.size(); ++i) {
            Matcher m = this.alP.get(i).matcher(line);
            if (!m.matches()) continue;
            switch (i) {
                case 0: {
                    this.event(m);
                }
            }
            i = this.alP.size();
            unknownPattern = false;
        }
        if (unknownPattern) {
            logger.warn((Object)("Unknown pattern: " + line));
            ++this.unknownLines;
        }
    }

    private void event(Matcher m) {
        Ofxgallery.Ofximage ofxImage = new Ofxgallery.Ofximage();
        ofxImage.setWikilink(m.group(1));
        ofxImage.setValue(m.group(2));
        WikiImageEvent event = new WikiImageEvent(ofxImage);
        this.leh.handleEvent((LogEvent)event);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        EhDebug leh = new EhDebug();
        WikiGalleryParser lp = new WikiGalleryParser((LogEventHandler)leh);
        LogListenerXml ll = new LogListenerXml("resources/data/gallery.xml", (LogParser)lp);
        ll.processSingle("/wikiinjection/wikicontent");
    }
}

