/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.markup;

import java.io.File;
import net.sf.exlp.util.io.ConfigLoader;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.io.StringIO;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.data.jaxb.Category;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Injections;
import org.openfuxml.addon.wiki.data.jaxb.Markup;
import org.openfuxml.addon.wiki.data.jaxb.ObjectFactory;
import org.openfuxml.addon.wiki.data.jaxb.Page;
import org.openfuxml.addon.wiki.data.jaxb.Replacements;
import org.openfuxml.addon.wiki.data.jaxb.Template;
import org.openfuxml.addon.wiki.data.jaxb.Templates;
import org.openfuxml.addon.wiki.data.jaxb.Wikiinjection;
import org.openfuxml.addon.wiki.data.jaxb.Wikireplace;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiConfigXmlXpathHelper;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.addon.wiki.util.WikiContentIO;
import org.openfuxml.exception.OfxConfigurationException;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.openfuxml.xml.renderer.cmp.Cmp;

public class WikiMarkupProcessor
extends AbstractWikiProcessor
implements WikiProcessor {
    static Log logger = LogFactory.getLog(WikiMarkupProcessor.class);
    private static final String ls = SystemUtils.LINE_SEPARATOR;
    private Replacements replacements;
    private Injections injections;
    private Templates templates;
    private String wikiText;
    private ObjectFactory of;
    private int templateCounter;
    private static String templateStartDelemiter = "{{";
    private static String templateEndDelemiter = "}}";
    @Deprecated
    private File dirInjection;
    private int injectionId;

    public WikiMarkupProcessor(Cmp cmp) throws OfxConfigurationException {
        this(cmp.getPreprocessor().getWiki().getMarkupProcessor().getReplacements(), cmp.getPreprocessor().getWiki().getMarkupProcessor().getInjections(), cmp.getPreprocessor().getWiki().getTemplates());
    }

    public WikiMarkupProcessor(Replacements replacements, Injections injections, Templates templates) throws OfxConfigurationException {
        this.templates = templates;
        this.replacements = WikiConfigXmlXpathHelper.initReplacements(replacements);
        this.injections = WikiConfigXmlXpathHelper.initInjections(injections);
        this.templateCounter = 0;
    }

    @Override
    protected void processCategory(Content content) throws OfxInternalProcessingException {
        Category category = content.getCategory();
        for (Page page : category.getPage()) {
            this.processPage(page);
        }
    }

    @Override
    protected void processPage(Content content) throws OfxInternalProcessingException {
        Page page = content.getPage();
        this.processPage(page);
    }

    protected void processPage(Page page) throws OfxInternalProcessingException {
        logger.debug((Object)("Processing Page: " + page.getName()));
        String fName = page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.txt);
        String txt = StringIO.loadTxt((File)this.srcDir, (String)fName);
        String result = this.process(txt, page.getName());
        StringIO.writeTxt((File)this.dstDir, (String)fName, (String)result);
    }

    public String process(String wikiPlain, String article) throws OfxInternalProcessingException {
        this.wikiText = wikiPlain;
        for (Wikireplace replace : this.replacements.getWikireplace()) {
            this.processReplacements(replace);
        }
        for (Wikiinjection inject : this.injections.getWikiinjection()) {
            this.wikiInject(inject, article);
        }
        for (Template template : this.templates.getTemplate()) {
            this.processTemplate(template);
        }
        return this.wikiText;
    }

    private void processReplacements(Wikireplace replace) {
        this.wikiText = this.wikiText.replaceAll(replace.getFrom(), replace.getTo());
    }

    private void processTemplate(Template template) throws OfxInternalProcessingException {
        logger.debug((Object)("Processing Template: " + template.getName()));
        int beginIndex = -1;
        while ((beginIndex = this.wikiText.indexOf(templateStartDelemiter + template.getName())) >= 0) {
            logger.warn((Object)"Nesting Templates are not supported!!");
            int endIndex = this.wikiText.indexOf(templateEndDelemiter);
            StringBuffer sb = new StringBuffer();
            sb.append(this.wikiText.substring(0, beginIndex));
            sb.append(this.createExternalTemplate(template, this.wikiText.substring(beginIndex + templateStartDelemiter.length() + template.getName().length(), endIndex)));
            sb.append(this.wikiText.substring(endIndex + templateEndDelemiter.length(), this.wikiText.length()));
            this.wikiText = sb.toString();
        }
    }

    private String createExternalTemplate(Template templateDef, String templateMarkup) throws OfxInternalProcessingException {
        Template template = new Template();
        template.setName(templateDef.getName());
        template.setId(this.getNextTemplateId());
        template.setMarkup(new Markup());
        template.getMarkup().setValue(templateMarkup);
        File f = new File(this.getDir(WikiProcessor.WikiDir.wikiTemplate), template.getId() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xml));
        JaxbUtil.save((File)f, (Object)template, (Object)this.nsPrefixMapper, (boolean)true);
        StringBuffer sb = new StringBuffer();
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append("<wiki:injection id=\"");
        sb.append(template.getId());
        sb.append("\"/>");
        sb.append(SystemUtils.LINE_SEPARATOR);
        return sb.toString();
    }

    private void wikiInject(Wikiinjection inject, String article) {
        while (this.wikiText.indexOf("<" + inject.getWikitag() + ">") > 0) {
            logger.warn((Object)"Injection should start, but currently NYI");
            inject.setId("" + this.injectionId);
            ++this.injectionId;
            inject.setArticle(article);
            StringBuffer sbDebug = new StringBuffer();
            String startTag = "<" + inject.getWikitag() + ">";
            int from = this.wikiText.indexOf(startTag);
            int to = this.wikiText.indexOf("</" + inject.getWikitag() + ">");
            StringBuffer injectionSb = WikiContentIO.toString(inject);
            logger.debug((Object)injectionSb);
            inject.setWikicontent(this.of.createWikiinjectionWikicontent());
            inject.getWikicontent().setValue(this.wikiText.substring(from + startTag.length(), to));
            WikiContentIO.toFile(inject, this.dirInjection);
            sbDebug.append("Injection: " + from + " " + to);
            sbDebug.append(" oldSize=" + this.wikiText.length());
            StringBuffer sb = new StringBuffer();
            sb.append(this.wikiText.substring(0, from - 1));
            if (inject.getOfxtag() != null && inject.getOfxtag().length() > 0) {
                sb.append(injectionSb);
                sb.append(ls);
            }
            sb.append(this.wikiText.substring(to + inject.getWikitag().length() + 3 + 1, this.wikiText.length()));
            this.wikiText = sb.toString();
            sbDebug.append(" newSize=" + this.wikiText.length());
            logger.debug((Object)sbDebug);
        }
    }

    private String getNextTemplateId() {
        ++this.templateCounter;
        return "" + this.templateCounter;
    }

    public static void main(String[] args) throws Exception {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        String propFile = "resources/properties/user.properties";
        if (args.length == 1) {
            propFile = args[0];
        }
        ConfigLoader.add((String)propFile);
        Configuration config = ConfigLoader.init();
        String fnCmp = config.getString("ofx.xml.cmp");
        String fnWikiTxt = config.getString("wiki.processor.test.markup");
        logger.debug((Object)("Cmp:  " + fnCmp));
        logger.debug((Object)("Wiki: " + fnWikiTxt));
        Cmp cmp = (Cmp)JaxbUtil.loadJAXB((String)fnCmp, Cmp.class);
        WikiMarkupProcessor wpMarkup = new WikiMarkupProcessor(cmp);
        String wikiText = StringIO.loadTxt((String)fnWikiTxt);
        logger.debug((Object)("Wiki (Before): " + wikiText));
        wikiText = wpMarkup.process(wikiText, "test");
        logger.debug((Object)("Wiki (After): " + wikiText));
    }

    public static enum InjectionType {
        xml,
        wiki;

    }
}

