/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.net.fetcher;

import java.text.DecimalFormat;
import java.util.Locale;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.io.txt.ExlpTxtWriter;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.actions.util.ProcessException;
import net.sourceforge.jwbf.core.contentRep.ArticleMeta;
import net.sourceforge.jwbf.core.contentRep.SimpleArticle;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.WikiTemplates;
import org.openfuxml.addon.wiki.processor.util.WikiBotFactory;

public class WikiPageFetcher {
    static Log logger = LogFactory.getLog(WikiPageFetcher.class);
    private MediaWikiBot bot;
    private String wikiText;
    private DecimalFormat df;

    public WikiPageFetcher(MediaWikiBot bot) {
        this.bot = bot;
        this.df = (DecimalFormat)DecimalFormat.getInstance(Locale.GERMAN);
        this.df.applyPattern("#,###,##0");
    }

    public void fetchText(String article) {
        try {
            SimpleArticle sa = new SimpleArticle((ArticleMeta)this.bot.readContent(article));
            this.wikiText = sa.getText();
        }
        catch (ActionException e) {
            logger.error((Object)e);
        }
        catch (ProcessException e) {
            logger.error((Object)e);
        }
        logger.debug((Object)("Article " + article + " fetched. " + this.df.format(this.wikiText.length()) + " characters."));
    }

    public void save(ExlpTxtWriter txtWriter) {
        txtWriter.add(this.wikiText);
        txtWriter.write();
    }

    public String getWikiText() {
        return this.wikiText;
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        WikiTemplates.init();
        WikiBotFactory wbf = new WikiBotFactory();
        WikiPageFetcher wtf = new WikiPageFetcher(wbf.createBot());
        wtf.fetchText("Bellagio");
    }
}

