/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.emitter.Emitter;
import org.openfuxml.addon.wiki.emitter.GlosstermEmitter;
import org.openfuxml.addon.wiki.emitter.ImageEmitter;
import org.openfuxml.addon.wiki.emitter.injection.OfxInjectionEmitter;
import org.openfuxml.addon.wiki.processor.ofx.emitter.AnchorEmitter;
import org.openfuxml.addon.wiki.processor.ofx.emitter.HeaderEmitter;
import org.openfuxml.addon.wiki.processor.ofx.emitter.NestingEmitter;
import org.openfuxml.addon.wiki.processor.ofx.emitter.OfxEmphasisEmitter;
import org.openfuxml.addon.wiki.processor.ofx.emitter.OfxListEmitter;
import org.openfuxml.addon.wiki.processor.ofx.emitter.SimpleMappingEmitter;

public class EmitterFactory {
    static Log logger = LogFactory.getLog(EmitterFactory.class);
    private XMLStreamWriter writer;
    private String injectionDir;

    public EmitterFactory(XMLStreamWriter writer, String injectionDir) {
        this.writer = writer;
        this.injectionDir = injectionDir;
    }

    public synchronized Emitter getEmitter(String elementName) {
        SimpleMappingEmitter emitter;
        block25: {
            try {
                HtmlElement htmlElement = HtmlElement.valueOf(elementName);
                switch (htmlElement) {
                    case sup: {
                        return new SimpleMappingEmitter(this, "hochgestellt");
                    }
                    case p: {
                        return new SimpleMappingEmitter(this, "ofx:paragraph");
                    }
                    case i: {
                        return new SimpleMappingEmitter(this, "kursiv");
                    }
                    case b: {
                        return new OfxEmphasisEmitter(this, OfxEmphasisEmitter.Emphasis.bold);
                    }
                    case strong: {
                        return new SimpleMappingEmitter(this, "fett");
                    }
                    case ul: {
                        return new OfxListEmitter(this, OfxListEmitter.Ordering.unordered);
                    }
                    case ol: {
                        return new OfxListEmitter(this, OfxListEmitter.Ordering.ordered);
                    }
                    case li: {
                        return new SimpleMappingEmitter(this, "list:item", "ofx:paragraph");
                    }
                    case a: {
                        return new AnchorEmitter(this);
                    }
                    case body: {
                        return new NestingEmitter(this);
                    }
                    case title: {
                        return new SimpleMappingEmitter(this, "ofx:title");
                    }
                    case wikiinjection: {
                        return new OfxInjectionEmitter(this, this.injectionDir);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!elementName.matches("h\\d")) break block25;
                return new HeaderEmitter(this, Integer.parseInt(elementName.substring(1)));
            }
        }
        logger.debug((Object)("Unknown element \"" + elementName + "\" using default structure"));
        if ("acronym".equals(elementName)) {
            return new GlosstermEmitter(this);
        }
        if ("img".equals(elementName)) {
            return new ImageEmitter(this);
        }
        if ("em".equals(elementName)) {
            return new SimpleMappingEmitter(this, "emphasis");
        }
        if ("cite".equals(elementName)) {
            return new SimpleMappingEmitter(this, "citation");
        }
        if ("code".equals(elementName)) {
            return new SimpleMappingEmitter(this, "code");
        }
        if ("pre".equals(elementName)) {
            return new SimpleMappingEmitter(this, "literallayout");
        }
        if ("del".equals(elementName)) {
            emitter = new SimpleMappingEmitter(this, "emphasis");
            emitter.setAttribute("role", "del");
            return emitter;
        }
        if ("ins".equals(elementName)) {
            emitter = new SimpleMappingEmitter(this, "emphasis");
            emitter.setAttribute("role", "ins");
            return emitter;
        }
        if ("sub".equals(elementName)) {
            return new SimpleMappingEmitter(this, "subscript");
        }
        logger.debug((Object)"NestingEmitter wird genommen");
        return new NestingEmitter(this);
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    public void setWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public static enum HtmlElement {
        title,
        p,
        i,
        b,
        strong,
        ol,
        ul,
        li,
        a,
        body,
        sup,
        wikiinjection;

    }
}

