/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.emitter;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openfuxml.addon.wiki.emitter.Emitter;
import org.openfuxml.addon.wiki.processor.ofx.EmitterFactory;
import org.xml.sax.Attributes;

public class NestingEmitter
implements Emitter {
    private Emitter next = null;
    private String elementName = null;
    private int nestLevel = 0;
    protected EmitterFactory ef;

    public NestingEmitter(EmitterFactory ef) {
        this.ef = ef;
    }

    @Override
    public void content(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
        if (this.next != null) {
            this.next.content(writer, ch, start, length);
        } else {
            this.localContent(writer, ch, start, length);
        }
    }

    @Override
    public final boolean end(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        --this.nestLevel;
        if (this.nestLevel > 0 && this.next != null) {
            if (this.next.end(writer, htmlElementName)) {
                this.next.close();
                this.next = null;
            }
            return false;
        }
        if (this.next != null) {
            this.next.close();
            this.next = null;
        }
        return this.localEnd(writer, htmlElementName);
    }

    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        return true;
    }

    protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        return true;
    }

    protected void localContent(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
        writer.writeCharacters(ch, start, length);
    }

    @Override
    public final boolean start(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        ++this.nestLevel;
        if (this.elementName == null) {
            this.elementName = htmlElementName;
            return this.localStart(writer, htmlElementName, atts);
        }
        if (this.next == null) {
            this.next = this.ef.getEmitter(htmlElementName);
        }
        if (!this.next.start(writer, htmlElementName, atts)) {
            this.next.close();
            this.next = null;
            if (this.permitsMultipleNexting()) {
                this.next = this.ef.getEmitter(htmlElementName);
                if (!this.next.start(writer, htmlElementName, atts)) {
                    throw new IllegalStateException();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean permitsMultipleNexting() {
        return true;
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.next != null) {
            this.next.close();
            this.next = null;
        }
    }
}

