/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.emitter;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.processor.ofx.EmitterFactory;
import org.openfuxml.addon.wiki.processor.ofx.emitter.NestingEmitter;
import org.xml.sax.Attributes;

public class OfxEmphasisEmitter
extends NestingEmitter {
    static Log logger = LogFactory.getLog(OfxEmphasisEmitter.class);
    private Map<String, String> attributes;
    private Style style;
    private Emphasis emphasis;
    private static final String tag = "ofx:emphasis";

    public OfxEmphasisEmitter(EmitterFactory ef, Emphasis emphasis) {
        super(ef);
        this.emphasis = emphasis;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    @Override
    protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        String elementId;
        writer.writeStartElement(tag);
        this.writeStyle(writer);
        this.writeEmphasis(writer);
        boolean hasId = false;
        if (this.attributes != null) {
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                writer.writeAttribute(attr.getKey(), attr.getValue());
            }
            if (this.attributes.containsKey("id")) {
                hasId = true;
            }
        }
        if (!hasId && (elementId = atts.getValue("id")) != null) {
            writer.writeAttribute("id", elementId);
        }
        return true;
    }

    @Override
    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        writer.writeEndElement();
        return true;
    }

    private void writeStyle(XMLStreamWriter writer) throws XMLStreamException {
    }

    private void writeEmphasis(XMLStreamWriter writer) throws XMLStreamException {
        switch (this.emphasis) {
            case bold: {
                writer.writeAttribute("bold", "true");
            }
        }
    }

    public static enum Emphasis {
        bold,
        italic,
        unterline;

    }

    public static enum Style {
        normal,
        typewriter;

    }
}

