/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.emitter;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.processor.ofx.EmitterFactory;
import org.openfuxml.addon.wiki.processor.ofx.emitter.NestingEmitter;
import org.xml.sax.Attributes;

public class OfxListEmitter
extends NestingEmitter {
    static Log logger = LogFactory.getLog(OfxListEmitter.class);
    private Map<String, String> attributes;
    private Ordering ordering;
    private static final String tag = "list:list";

    public OfxListEmitter(EmitterFactory ef, Ordering ordering) {
        super(ef);
        this.ordering = ordering;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    @Override
    protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        String elementId;
        writer.writeStartElement(tag);
        switch (this.ordering) {
            case ordered: {
                this.typeOrdered(writer);
                break;
            }
            case unordered: {
                this.typeUnordered(writer);
            }
        }
        boolean hasId = false;
        if (this.attributes != null) {
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                writer.writeAttribute(attr.getKey(), attr.getValue());
            }
            if (this.attributes.containsKey("id")) {
                hasId = true;
            }
        }
        if (!hasId && (elementId = atts.getValue("id")) != null) {
            writer.writeAttribute("id", elementId);
        }
        return true;
    }

    @Override
    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        writer.writeEndElement();
        return true;
    }

    private void typeOrdered(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("list:type");
        writer.writeAttribute("ordering", "ordered");
        writer.writeEndElement();
    }

    private void typeUnordered(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("list:type");
        writer.writeAttribute("ordering", "unordered");
        writer.writeEndElement();
    }

    public static enum Ordering {
        ordered,
        unordered;

    }
}

