/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.emitter;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.processor.ofx.EmitterFactory;
import org.openfuxml.addon.wiki.processor.ofx.emitter.NestingEmitter;
import org.xml.sax.Attributes;

public class SimpleMappingEmitter
extends NestingEmitter {
    static Log logger = LogFactory.getLog(SimpleMappingEmitter.class);
    private final String[] tags;
    private Map<String, String> attributes;

    public SimpleMappingEmitter(EmitterFactory ef, String ... ofxTagNames) {
        super(ef);
        this.tags = ofxTagNames;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    @Override
    protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
        String elementId;
        for (String tag : this.tags) {
            writer.writeStartElement(tag);
        }
        boolean hasId = false;
        if (this.attributes != null) {
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                writer.writeAttribute(attr.getKey(), attr.getValue());
            }
            if (this.attributes.containsKey("id")) {
                hasId = true;
            }
        }
        if (!hasId && (elementId = atts.getValue("id")) != null) {
            writer.writeAttribute("id", elementId);
        }
        return true;
    }

    @Override
    protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
        logger.trace((Object)("localEnd " + this.tags.length));
        for (int x = 0; x < this.tags.length; ++x) {
            writer.writeEndElement();
        }
        return true;
    }
}

