/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.ofx.xml;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.exlp.util.io.StringIO;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.openfuxml.addon.wiki.FormattingXMLStreamWriter;
import org.openfuxml.addon.wiki.WikiTemplates;
import org.openfuxml.addon.wiki.data.jaxb.Page;
import org.openfuxml.addon.wiki.processor.ofx.OfxHtmlContentHandler;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.addon.wiki.util.IgnoreDtdEntityResolver;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.exception.OfxAuthoringException;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WikiPageProcessor
extends AbstractWikiProcessor {
    static Log logger = LogFactory.getLog(WikiPageProcessor.class);

    public WikiPageProcessor() {
        WikiTemplates.init();
    }

    public void processPage(Page page) throws OfxAuthoringException, OfxInternalProcessingException {
        this.checkPageConfig(page);
        try {
            String srcName = page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xhtml);
            String dstName = page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xml);
            String txtMarkup = StringIO.loadTxt((File)this.srcDir, (String)srcName);
            String result = this.process(txtMarkup, page.getName());
            File fDst = new File(this.dstDir, dstName);
            Document doc = JDomUtil.txtToDoc((String)result);
            doc = this.checkTransparent(doc, page.getSection());
            logger.warn((Object)"Content Trimmer deactivated here");
            JDomUtil.save((Document)doc, (File)fDst, (Format)Format.getRawFormat());
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
        }
        catch (XMLStreamException e) {
            logger.error((Object)e);
        }
        catch (SAXException e) {
            logger.error((Object)e);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
    }

    private Document checkTransparent(Document doc, Section section) throws OfxInternalProcessingException {
        if (section.isSetTransparent() && section.isTransparent()) {
            Element rootElement = doc.getRootElement();
            if (rootElement.getName().equalsIgnoreCase(Section.class.getSimpleName())) {
                rootElement.setAttribute("transparent", "true");
                logger.debug((Object)rootElement.getName());
            } else {
                throw new OfxInternalProcessingException("Root element <" + rootElement.getName() + "> of Wiki.Processing not expected");
            }
        }
        return doc;
    }

    public Element process(String xhtmlContent) {
        Element result = null;
        try {
            String xml = this.process(xhtmlContent, "dummy");
            Document doc = JDomUtil.txtToDoc((String)xml);
            result = doc.getRootElement();
            result.detach();
            Element eTitle = (Element)result.getChildren().get(0);
            eTitle.detach();
            result.setAttribute("transparent", "true");
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
        }
        catch (XMLStreamException e) {
            logger.error((Object)e);
        }
        catch (SAXException e) {
            logger.error((Object)e);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public String process(String xhtmlContent, String titleText) throws IOException, ParserConfigurationException, XMLStreamException, SAXException {
        Object[] objects = new Object[2];
        objects[0] = titleText;
        String header = MessageFormat.format(WikiTemplates.htmlHeader, objects);
        StringBuffer sb = new StringBuffer();
        sb.append(header);
        sb.append(xhtmlContent);
        sb.append(WikiTemplates.htmlFooter);
        logger.debug((Object)("Parsing: " + sb.length() + " characters"));
        InputSource inputSource = new InputSource(new StringReader(sb.toString()));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser saxParser = factory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setEntityResolver(IgnoreDtdEntityResolver.getInstance());
        StringWriter out = new StringWriter();
        XMLStreamWriter writer = this.createXMLStreamWriter(out);
        logger.warn((Object)"Using dummy String injectionDir");
        OfxHtmlContentHandler contentHandler = new OfxHtmlContentHandler(writer, ".");
        xmlReader.setContentHandler(contentHandler);
        xmlReader.parse(inputSource);
        writer.close();
        String result = out.toString();
        result = this.addNS(result);
        return result;
    }

    private String addNS(String xml) {
        int indexXml = xml.indexOf(">");
        int indexRoot = xml.substring(indexXml + 1, xml.length()).indexOf(">");
        StringBuffer sb = new StringBuffer();
        sb.append(xml.substring(0, indexXml + indexRoot + 1));
        sb.append(" xmlns:ofx=\"http://www.openfuxml.org\"");
        sb.append(" xmlns:list=\"http://www.openfuxml.org/list\"");
        sb.append(" xmlns:table=\"http://www.openfuxml.org/table\"");
        sb.append(" xmlns:layout=\"http://www.openfuxml.org/layout\"");
        sb.append(" xmlns:wiki=\"http://www.openfuxml.org/wiki\"");
        sb.append(xml.substring(indexXml + indexRoot + 1, xml.length()));
        return sb.toString();
    }

    protected XMLStreamWriter createXMLStreamWriter(Writer out) {
        XMLStreamWriter writer;
        try {
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        }
        catch (XMLStreamException e1) {
            throw new IllegalStateException(e1);
        }
        catch (FactoryConfigurationError e1) {
            throw new IllegalStateException(e1);
        }
        return new FormattingXMLStreamWriter(writer);
    }

    private void checkPageConfig(Page page) throws OfxAuthoringException {
        JaxbUtil.debug((Object)page);
        boolean sSection = page.isSetSection();
        if (!sSection) {
            throw new OfxAuthoringException("None of <section>  selected!");
        }
    }
}

