/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.pre;

import java.util.List;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Contents;
import org.openfuxml.content.ofx.Ofxdoc;
import org.openfuxml.content.ofx.Section;
import org.openfuxml.content.ofx.Sections;
import org.openfuxml.exception.OfxAuthoringException;

public class WikiExternalIntegrator {
    static Log logger = LogFactory.getLog(WikiExternalIntegrator.class);
    private Namespace ns;
    private XPath xpath;
    private int counter;
    private String wikiXmlDirName;
    private Ofxdoc ofxDocWithWikisAsExternal;
    private Contents wikiQueries;

    public WikiExternalIntegrator(String wikiXmlDirName) {
        this.wikiXmlDirName = wikiXmlDirName;
        try {
            this.ns = Namespace.getNamespace((String)"ofx", (String)"http://www.openfuxml.org");
            this.ns = Namespace.getNamespace((String)"wiki", (String)"http://www.openfuxml.org/wiki");
            this.xpath = XPath.newInstance((String)"//wiki:content");
            this.xpath.addNamespace(this.ns);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        this.xpath.addNamespace(this.ns);
        this.counter = 1;
        this.wikiQueries = new Contents();
    }

    public void integrateWikiAsExternal(Ofxdoc ofxDoc) throws OfxAuthoringException {
        Document doc = JaxbUtil.toDocument((Object)ofxDoc);
        try {
            List list = this.xpath.selectNodes((Object)doc.getRootElement());
            logger.debug((Object)(list.size() + " <wiki:content/> found"));
            for (Element eChild : list) {
                logger.trace((Object)eChild.getName());
                Content wikiContent = (Content)JDomUtil.toJaxb((Element)eChild, Content.class);
                Element eOfx = this.processWikiContent(wikiContent);
                wikiContent.setSource(eOfx.getAttributeValue("source"));
                this.wikiQueries.getContent().add(wikiContent);
                int index = eChild.getParentElement().indexOf((org.jdom.Content)eChild);
                eChild.getParentElement().addContent(index, (org.jdom.Content)eOfx);
                eChild.detach();
            }
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        this.ofxDocWithWikisAsExternal = (Ofxdoc)JDomUtil.toJaxb((Document)doc, Ofxdoc.class);
    }

    public Ofxdoc getResult() {
        return this.ofxDocWithWikisAsExternal;
    }

    public Contents getWikiQueries() {
        return this.wikiQueries;
    }

    private Element processWikiContent(Content wikiContent) throws OfxAuthoringException {
        Element e = null;
        if (wikiContent.isSetPage()) {
            e = this.getSection(wikiContent);
        } else if (wikiContent.isSetCategory()) {
            e = this.getCategory(wikiContent);
        } else {
            throw new OfxAuthoringException("Element wiki:content has no known child");
        }
        return e;
    }

    private Element getCategory(Content wikiContent) {
        Sections ofxSections = new Sections();
        ofxSections.setExternal(true);
        ofxSections.setSource(this.wikiXmlDirName + "/" + this.counter + ".xml");
        ++this.counter;
        Element eResult = JaxbUtil.toDocument((Object)ofxSections).getRootElement();
        eResult.detach();
        return eResult;
    }

    private Element getSection(Content wikiContent) {
        Section ofxSection = new Section();
        ofxSection.setExternal(true);
        ofxSection.setSource(this.wikiXmlDirName + "/" + this.counter + ".xml");
        ++this.counter;
        Element eResult = JaxbUtil.toDocument((Object)ofxSection).getRootElement();
        eResult.detach();
        return eResult;
    }
}

