/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.template;

import java.util.List;
import net.sf.exlp.util.io.ConfigLoader;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import net.sf.exlp.xml.ns.NsPrefixMapperInterface;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.content.ofx.Ofxdoc;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.openfuxml.xml.ns.OfxNsPrefixMapper;

public class WikiTemplateCorrector
extends AbstractWikiProcessor
implements WikiProcessor {
    static Log logger = LogFactory.getLog(WikiTemplateCorrector.class);
    private final String startDelimiter = "&lt;wiki:injection id=&quot;";
    private final String endDelimiter = "&quot;/&gt;";
    private OfxNsPrefixMapper nsPrefixMapper = new OfxNsPrefixMapper();
    private XPath xpath;

    public WikiTemplateCorrector() {
        try {
            Namespace nsOfx = Namespace.getNamespace((String)"ofx", (String)"http://www.openfuxml.org");
            Namespace nsWiki = Namespace.getNamespace((String)"wiki", (String)"http://www.openfuxml.org/wiki");
            this.xpath = XPath.newInstance((String)"//wiki:template");
            this.xpath.addNamespace(nsOfx);
            this.xpath.addNamespace(nsWiki);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
    }

    public Ofxdoc correctTemplateInjections(Ofxdoc ofxDoc) throws OfxInternalProcessingException {
        Document doc = this.transformToElement(ofxDoc);
        doc = this.exchangeParagraphByTemplate(doc);
        ofxDoc = (Ofxdoc)JDomUtil.toJaxb((Document)doc, Ofxdoc.class);
        return ofxDoc;
    }

    private Document exchangeParagraphByTemplate(Document doc) {
        try {
            Namespace nsOfx = Namespace.getNamespace((String)"ofx", (String)"http://www.openfuxml.org");
            Namespace nsWiki = Namespace.getNamespace((String)"wiki", (String)"http://www.openfuxml.org/wiki");
            XPath xpath = XPath.newInstance((String)"//wiki:template");
            xpath.addNamespace(nsOfx);
            xpath.addNamespace(nsWiki);
            Element result = this.exchangeParagraphByTemplate(doc.getRootElement(), xpath);
            result.detach();
            doc.setRootElement(result);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        return doc;
    }

    private Element exchangeParagraphByTemplate(Element rootElement, XPath xpath) {
        try {
            List list = xpath.selectNodes((Object)rootElement);
            logger.debug((Object)(list.size() + " sections"));
            for (Element eTemplate : list) {
                int index = eTemplate.getParentElement().getParentElement().indexOf((Content)eTemplate.getParentElement());
                Element parent = eTemplate.getParentElement().getParentElement();
                eTemplate.detach();
                parent.removeContent(index);
                parent.addContent(index, (Content)this.createExternalTemplate(eTemplate));
            }
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        return rootElement;
    }

    private Element createExternalTemplate(Element eTemplate) {
        StringBuffer sb = new StringBuffer();
        sb.append(WikiProcessor.WikiDir.ofxTemplate.toString());
        sb.append("/").append(eTemplate.getAttributeValue("id")).append(".xml");
        eTemplate.setAttribute("external", "true");
        eTemplate.setAttribute("source", sb.toString());
        return eTemplate;
    }

    private Document transformToElement(Ofxdoc ofxDoc) {
        String txt = JaxbUtil.toString((Object)ofxDoc, (NsPrefixMapperInterface)this.nsPrefixMapper, (boolean)true);
        int beginIndex = -1;
        while ((beginIndex = txt.indexOf("&lt;wiki:injection id=&quot;")) >= 0) {
            String behindStart = txt.substring(beginIndex + "&lt;wiki:injection id=&quot;".length(), txt.length());
            int endIndex = behindStart.indexOf("&quot;/&gt;");
            String id = behindStart.substring(0, endIndex);
            StringBuffer sb = new StringBuffer();
            sb.append(txt.substring(0, beginIndex));
            sb.append(this.getTemplateXml(id));
            sb.append(txt.substring(beginIndex + "&lt;wiki:injection id=&quot;".length() + id.length() + "&quot;/&gt;".length()));
            txt = sb.toString();
        }
        Document doc = null;
        try {
            doc = JDomUtil.txtToDoc((String)txt);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        return doc;
    }

    private String getTemplateXml(String id) {
        StringBuffer sb = new StringBuffer();
        sb.append("<wiki:template id=\"");
        sb.append(id);
        sb.append("\"/>");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        String propFile = "resources/properties/user.properties";
        if (args.length == 1) {
            propFile = args[0];
        }
        ConfigLoader.add((String)propFile);
        Configuration config = ConfigLoader.init();
        String fnOfx = config.getString("wiki.processor.test.template.correct");
        Ofxdoc ofxDoc = (Ofxdoc)JaxbUtil.loadJAXB((String)fnOfx, Ofxdoc.class);
        WikiTemplateCorrector templateCorrector = new WikiTemplateCorrector();
        templateCorrector.correctTemplateInjections(ofxDoc);
    }
}

