/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.template;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.openfuxml.addon.wiki.WikiInlineProcessor;
import org.openfuxml.addon.wiki.data.jaxb.Template;
import org.openfuxml.addon.wiki.data.jaxb.Templates;
import org.openfuxml.addon.wiki.processor.template.transformator.WikiTemplateKeyValueTransformator;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiConfigXmlXpathHelper;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.exception.OfxConfigurationException;
import org.openfuxml.exception.OfxInternalProcessingException;

public class WikiTemplateProcessor
extends AbstractWikiProcessor {
    static Log logger = LogFactory.getLog(WikiTemplateProcessor.class);
    private Templates templates;
    private WikiTemplateKeyValueTransformator kvTransformator;

    public WikiTemplateProcessor(WikiInlineProcessor wikiInlineProcessor, Templates templates) {
        this.templates = templates;
        this.kvTransformator = new WikiTemplateKeyValueTransformator(wikiInlineProcessor);
    }

    public void process() throws OfxInternalProcessingException, OfxConfigurationException {
        File fTemplateDir = this.getDir(WikiProcessor.WikiDir.wikiTemplate);
        for (File fTemplate : fTemplateDir.listFiles()) {
            try {
                Template template = (Template)JaxbUtil.loadJAXB((String)fTemplate.getAbsolutePath(), Template.class);
                File fOfxTemplate = new File(this.getDir(WikiProcessor.WikiDir.ofxTemplate), template.getId() + ".xml");
                Document doc = this.processTemplate(template);
                JDomUtil.save((Document)doc, (File)fOfxTemplate, (Format)Format.getRawFormat());
            }
            catch (FileNotFoundException e) {
                throw new OfxInternalProcessingException(e.getMessage());
            }
        }
    }

    private Document processTemplate(Template template) throws OfxConfigurationException {
        Document doc = new Document();
        Template templateDef = WikiConfigXmlXpathHelper.getTemplate(this.templates, template.getName());
        Element e = this.kvTransformator.transform(templateDef, template);
        doc.setRootElement(e);
        return doc;
    }
}

