/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.template.exlp.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.exlp.event.LogEvent;
import net.sf.exlp.event.LogEventHandler;
import net.sf.exlp.parser.AbstractLogParser;
import net.sf.exlp.parser.LogParser;
import net.sf.exlp.util.io.LoggerInit;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.data.jaxb.Markup;
import org.openfuxml.addon.wiki.data.jaxb.TemplateKv;
import org.openfuxml.addon.wiki.processor.template.exlp.event.WikiKeyValueEvent;

public class WikiKeyValueParser
extends AbstractLogParser
implements LogParser {
    static Log logger = LogFactory.getLog(WikiKeyValueParser.class);
    private TemplateKv wikiKV;

    public WikiKeyValueParser(LogEventHandler leh) {
        super(leh);
        this.pattern.add(Pattern.compile("^$"));
        this.pattern.add(Pattern.compile("^\\|([a-zA-Z]*)=(.*)"));
        this.pattern.add(Pattern.compile("(.*)"));
        logger.debug((Object)("Pattern defined: " + this.pattern.size()));
    }

    public void parseLine(String line) {
        ++this.allLines;
        boolean unknownPattern = true;
        for (int i = 0; i < this.pattern.size(); ++i) {
            Matcher m = ((Pattern)this.pattern.get(i)).matcher(line);
            if (!m.matches()) continue;
            switch (i) {
                case 0: {
                    this.blank();
                    break;
                }
                case 1: {
                    this.key(m);
                    break;
                }
                case 2: {
                    this.value(m);
                }
            }
            i = this.pattern.size();
            unknownPattern = false;
        }
        if (unknownPattern) {
            logger.warn((Object)("Unknown pattern: " + line));
            ++this.unknownLines;
        }
    }

    private void blank() {
        if (this.wikiKV != null) {
            // empty if block
        }
    }

    private void key(Matcher m) {
        if (this.wikiKV != null) {
            this.event();
        }
        this.wikiKV = new TemplateKv();
        this.wikiKV.setKey(m.group(1));
        this.wikiKV.setMarkup(new Markup());
        this.wikiKV.getMarkup().setValue(m.group(2));
    }

    public void value(Matcher m) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.wikiKV.getMarkup().getValue());
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append(m.group(0));
        this.wikiKV.getMarkup().setValue(sb.toString());
    }

    public void close() {
        if (this.wikiKV != null) {
            this.event();
        }
    }

    public void event() {
        WikiKeyValueEvent event = new WikiKeyValueEvent(this.wikiKV);
        this.leh.handleEvent((LogEvent)event);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        logger.warn((Object)"This is only a pattern test-class!");
        String sPattern = "^\\|([a-zA-Z]*)=(.*)";
        String sTest = "|Goal=blabla bla blablub";
        logger.debug((Object)("Pattern: " + sPattern));
        logger.debug((Object)("Test:    " + sTest));
        Pattern p = Pattern.compile(sPattern);
        Matcher m = p.matcher(sTest);
        logger.debug((Object)m.matches());
        if (m.matches()) {
            logger.debug((Object)("Group Count " + m.groupCount()));
            for (int i = 0; i <= m.groupCount(); ++i) {
                logger.debug((Object)(i + " " + m.group(i)));
            }
        }
    }
}

