/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.util;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openfuxml.addon.wiki.data.exception.OfxWikiException;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Contents;
import org.openfuxml.addon.wiki.processor.markup.WikiMarkupProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.exception.OfxAuthoringException;
import org.openfuxml.exception.OfxInternalProcessingException;
import org.openfuxml.xml.ns.OfxNsPrefixMapper;

public abstract class AbstractWikiProcessor {
    static Log logger = LogFactory.getLog(AbstractWikiProcessor.class);
    protected File srcDir;
    protected File dstDir;
    protected OfxNsPrefixMapper nsPrefixMapper = new OfxNsPrefixMapper();
    private Map<WikiProcessor.WikiDir, File> mDirs = new Hashtable<WikiProcessor.WikiDir, File>();

    public void setDirectory(WikiProcessor.WikiDir type, File dir) throws OfxInternalProcessingException {
        if (this.mDirs.containsKey((Object)type)) {
            throw new OfxInternalProcessingException("Dir Definition for " + (Object)((Object)type) + " exists!");
        }
        this.mDirs.put(type, dir);
    }

    protected File getDir(WikiProcessor.WikiDir type) throws OfxInternalProcessingException {
        if (!this.mDirs.containsKey((Object)type)) {
            throw new OfxInternalProcessingException("No Dir Definition for " + (Object)((Object)type));
        }
        return this.mDirs.get((Object)type);
    }

    public void setDirectories(File srcDir, File dstDir) {
        this.srcDir = srcDir;
        this.dstDir = dstDir;
        if (srcDir != null) {
            logger.trace((Object)("Directory Src: " + srcDir.getAbsolutePath()));
        }
        if (dstDir != null) {
            logger.trace((Object)("Directory Dst: " + dstDir.getAbsolutePath()));
        }
    }

    public void process(Contents wikiQueries) throws OfxWikiException, OfxAuthoringException, OfxInternalProcessingException {
        for (Content content : wikiQueries.getContent()) {
            if (content.isSetPage()) {
                this.processPage(content);
                continue;
            }
            if (content.isSetCategory()) {
                this.processCategory(content);
                continue;
            }
            throw new OfxWikiException("No " + WikiMarkupProcessor.class.getSimpleName() + " available for this element");
        }
    }

    protected void processPage(Content content) throws OfxAuthoringException, OfxInternalProcessingException {
        logger.warn((Object)"Must be Overridden!");
    }

    protected void processCategory(Content content) throws OfxAuthoringException, OfxInternalProcessingException {
        logger.warn((Object)"Must be Overridden!");
    }
}

