/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.util;

import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.jwbf.core.actions.HttpActionClient;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.openfuxml.addon.wiki.data.jaxb.Server;
import org.openfuxml.addon.wiki.data.jaxb.Servers;

public class WikiBotFactory {
    static Log logger = LogFactory.getLog(WikiBotFactory.class);
    private URL url;
    private String httpUsername;
    private String httpPassword;
    private String wikiUsername;
    private String wikiPassword;
    private MediaWikiBot bot;

    public WikiBotFactory() {
        this.setUrl("http://de.wikipedia.org/w/");
    }

    public WikiBotFactory(Servers wikiServers) {
        Server wikiServer = (Server)wikiServers.getServer().get(0);
        try {
            this.url = new URL(wikiServer.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setUrl(String wikiURL) {
        try {
            this.url = new URL(wikiURL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setHttpDigestAuth(String httpUsername, String httpPassword) {
        this.httpUsername = httpUsername;
        this.httpPassword = httpPassword;
    }

    public void setWikiAuth(String wikiUsername, String wikiPassword) {
        this.wikiUsername = wikiUsername;
        this.wikiPassword = wikiPassword;
    }

    public MediaWikiBot getBot() {
        if (this.bot == null) {
            logger.debug((Object)"Creating MediaWikiBot");
            this.bot = this.createBot();
        }
        return this.bot;
    }

    public MediaWikiBot createBot() {
        MediaWikiBot bot = null;
        try {
            bot = new MediaWikiBot(this.url);
            if (this.httpUsername != null && this.httpPassword != null) {
                bot.setConnection(this.createActionClient());
            }
            if (this.wikiUsername != null && this.wikiPassword != null) {
                bot.login(this.wikiUsername, this.wikiPassword);
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
        }
        catch (ActionException e) {
            logger.error((Object)e);
        }
        return bot;
    }

    private HttpActionClient createActionClient() throws MalformedURLException {
        AuthScope scope = new AuthScope(this.url.getHost(), this.url.getDefaultPort());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.httpUsername, this.httpPassword);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getCredentialsProvider().setCredentials(scope, (Credentials)credentials);
        HttpActionClient actionClient = new HttpActionClient((HttpClient)httpclient, this.url);
        return actionClient;
    }
}

