/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.util;

import java.io.FileNotFoundException;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JDomUtil;
import net.sf.exlp.util.xml.JaxbUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.openfuxml.addon.wiki.data.jaxb.Injections;
import org.openfuxml.addon.wiki.data.jaxb.Replacements;
import org.openfuxml.addon.wiki.data.jaxb.Template;
import org.openfuxml.addon.wiki.data.jaxb.Templates;
import org.openfuxml.exception.OfxConfigurationException;

public class WikiConfigXmlXpathHelper {
    static Log logger = LogFactory.getLog(WikiConfigXmlXpathHelper.class);

    public static synchronized Template getTemplate(Templates templates, String name) throws OfxConfigurationException {
        Template result = new Template();
        try {
            XPath xpath = XPath.newInstance((String)("//wiki:template[@name='" + name + "']"));
            xpath.addNamespace(Namespace.getNamespace((String)"ofx", (String)"http://www.openfuxml.org"));
            xpath.addNamespace(Namespace.getNamespace((String)"wiki", (String)"http://www.openfuxml.org/wiki"));
            Document doc = JaxbUtil.toDocument((Object)templates);
            Element e = (Element)xpath.selectSingleNode((Object)doc);
            if (e == null) {
                throw new OfxConfigurationException("No template definition for templateName=" + name);
            }
            result = (Template)JDomUtil.toJaxb((Element)e, Template.class);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public static synchronized Replacements initReplacements(Replacements replacements) throws OfxConfigurationException {
        if (replacements.isSetExternal() && replacements.isExternal()) {
            try {
                if (!replacements.isSetSource()) {
                    throw new OfxConfigurationException("Replacement is set to external, but no source definded");
                }
                replacements = (Replacements)JaxbUtil.loadJAXB((String)replacements.getSource(), Replacements.class);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new OfxConfigurationException(e.getMessage());
            }
        }
        return replacements;
    }

    public static synchronized Injections initInjections(Injections injections) throws OfxConfigurationException {
        if (injections.isSetExternal() && injections.isExternal()) {
            try {
                if (!injections.isSetSource()) {
                    throw new OfxConfigurationException(Injections.class.getSimpleName() + " is set to external, but no source definded");
                }
                logger.debug((Object)("Loading external " + Injections.class.getSimpleName() + " file: " + injections.getSource()));
                injections = (Injections)JaxbUtil.loadJAXB((String)injections.getSource(), Injections.class);
            }
            catch (FileNotFoundException e) {
                throw new OfxConfigurationException(e.getMessage());
            }
        }
        logger.debug((Object)JaxbUtil.toString((Object)injections));
        return injections;
    }

    public static void main(String[] args) throws Exception {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("resources/config");
        loggerInit.init();
        String fnInjections = "resources/config/wiki/wikiinjection.xml";
        Injections injections = (Injections)JaxbUtil.loadJAXB((String)fnInjections, Injections.class);
        logger.debug((Object)JaxbUtil.toString((Object)injections));
    }
}

