/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.xhtml;

import java.io.File;
import net.sf.exlp.util.io.StringIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.JDOMException;
import org.openfuxml.addon.wiki.data.jaxb.Category;
import org.openfuxml.addon.wiki.data.jaxb.Content;
import org.openfuxml.addon.wiki.data.jaxb.Page;
import org.openfuxml.addon.wiki.processor.util.AbstractWikiProcessor;
import org.openfuxml.addon.wiki.processor.util.WikiProcessor;
import org.openfuxml.addon.wiki.processor.xhtml.mods.OfxPushUp;
import org.openfuxml.addon.wiki.processor.xhtml.mods.XhtmlAHxMerge;
import org.openfuxml.addon.wiki.processor.xhtml.mods.XhtmlCodePreMover;

public class XhtmlFinalProcessor
extends AbstractWikiProcessor
implements WikiProcessor {
    static Log logger = LogFactory.getLog(XhtmlFinalProcessor.class);

    @Override
    protected void processCategory(Content content) {
        Category category = content.getCategory();
        for (Page page : category.getPage()) {
            this.processPage(page);
        }
    }

    @Override
    protected void processPage(Content content) {
        Page page = content.getPage();
        this.processPage(page);
    }

    public void processPage(Page page) {
        String fNameXhtml = page.getFile() + "." + (Object)((Object)WikiProcessor.WikiFileExtension.xhtml);
        String txtMarkup = StringIO.loadTxt((File)this.srcDir, (String)fNameXhtml);
        String result = this.process(txtMarkup);
        StringIO.writeTxt((File)this.dstDir, (String)fNameXhtml, (String)result);
    }

    public String process(String xHtml) {
        OfxPushUp pushUp = new OfxPushUp();
        XhtmlAHxMerge merger = new XhtmlAHxMerge();
        XhtmlCodePreMover moveCodePre = new XhtmlCodePreMover();
        xHtml = pushUp.moveOfxElements(xHtml);
        xHtml = merger.merge(xHtml);
        try {
            xHtml = moveCodePre.move(xHtml);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        xHtml = this.removeWellFormed(xHtml);
        return xHtml;
    }

    public String removeWellFormed(String text) {
        int testIndex = text.indexOf("<wiki />");
        if (testIndex > 0) {
            return "";
        }
        int from = text.indexOf("<wiki>") + 6;
        int to = text.lastIndexOf("</wiki>");
        return text.substring(from, to);
    }
}

