/*
 * Decompiled with CFR 0.152.
 */
package org.openfuxml.addon.wiki.processor.xhtml.mods;

import java.util.Iterator;
import java.util.List;
import net.sf.exlp.util.xml.JDomUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class XhtmlCodePreMover {
    static Log logger = LogFactory.getLog(XhtmlCodePreMover.class);
    private XPath xpathCode;
    private XPath xpParent;
    private XPath xpathPre;
    private Element rootElement;

    public XhtmlCodePreMover() {
        try {
            this.xpathCode = XPath.newInstance((String)"//code");
            this.xpParent = XPath.newInstance((String)"..");
            this.xpathPre = XPath.newInstance((String)"following-sibling::pre[position()=1]");
        }
        catch (JDOMException e) {
            logger.error((Object)e);
        }
    }

    public String move(String xHtmlText) throws JDOMException {
        Document doc = JDomUtil.txtToDoc((String)xHtmlText);
        this.rootElement = doc.getRootElement();
        logger.debug((Object)JDomUtil.docToTxt((Document)doc));
        this.process();
        xHtmlText = JDomUtil.docToTxt((Document)doc);
        return xHtmlText;
    }

    private void process() throws JDOMException {
        List list = this.xpathCode.selectNodes((Object)this.rootElement);
        logger.debug((Object)(list.size() + " <code> elements found in " + this.rootElement.getName()));
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Element eP;
            logger.trace((Object)"Processing code *************");
            Element eCode = (Element)iter.next();
            if (eCode.getChildren().size() != 0 || (eP = (Element)this.xpParent.selectSingleNode((Object)eCode)) == null) continue;
            logger.trace((Object)("eP=" + eP));
            Element ePre = (Element)this.xpathPre.selectSingleNode((Object)eP);
            if (ePre == null) continue;
            logger.trace((Object)("ePre=" + ePre));
            int iP = eP.getParent().indexOf((Content)eP);
            int iPre = ePre.getParent().indexOf((Content)ePre);
            logger.trace((Object)(iP + " " + iPre));
            if (iPre != iP + 1) continue;
            eCode.setText(ePre.getText());
            ePre.detach();
            Element eCodeGrandParent = eCode.getParentElement().getParentElement();
            int iCodeParent = eCodeGrandParent.indexOf((Content)eCode.getParentElement());
            logger.debug((Object)iCodeParent);
            eCode.detach();
            eCodeGrandParent.removeContent(iCodeParent);
            eCodeGrandParent.addContent(iCodeParent, (Content)eCode);
        }
    }
}

